/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.servicecatalog.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.servicecatalog.model.ProvisionProductRequest;
import com.amazonaws.services.servicecatalog.model.ProvisioningParameter;
import com.amazonaws.services.servicecatalog.model.Tag;
import com.amazonaws.services.servicecatalog.model.transform.ProvisioningParameterJsonMarshaller;
import com.amazonaws.services.servicecatalog.model.transform.TagJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.IdempotentUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public class ProvisionProductRequestMarshaller
implements Marshaller<Request<ProvisionProductRequest>, ProvisionProductRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ProvisionProductRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<ProvisionProductRequest> marshall(ProvisionProductRequest provisionProductRequest) {
        if (provisionProductRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)provisionProductRequest, "AWSServiceCatalog");
        request.addHeader("X-Amz-Target", "AWS242ServiceCatalogService.ProvisionProduct");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<String> list;
            List<Tag> tagsList;
            List<ProvisioningParameter> provisioningParametersList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (provisionProductRequest.getAcceptLanguage() != null) {
                jsonGenerator.writeFieldName("AcceptLanguage").writeValue(provisionProductRequest.getAcceptLanguage());
            }
            if (provisionProductRequest.getProductId() != null) {
                jsonGenerator.writeFieldName("ProductId").writeValue(provisionProductRequest.getProductId());
            }
            if (provisionProductRequest.getProvisioningArtifactId() != null) {
                jsonGenerator.writeFieldName("ProvisioningArtifactId").writeValue(provisionProductRequest.getProvisioningArtifactId());
            }
            if (provisionProductRequest.getPathId() != null) {
                jsonGenerator.writeFieldName("PathId").writeValue(provisionProductRequest.getPathId());
            }
            if (provisionProductRequest.getProvisionedProductName() != null) {
                jsonGenerator.writeFieldName("ProvisionedProductName").writeValue(provisionProductRequest.getProvisionedProductName());
            }
            if ((provisioningParametersList = provisionProductRequest.getProvisioningParameters()) != null) {
                jsonGenerator.writeFieldName("ProvisioningParameters");
                jsonGenerator.writeStartArray();
                for (ProvisioningParameter provisioningParameter : provisioningParametersList) {
                    if (provisioningParameter == null) continue;
                    ProvisioningParameterJsonMarshaller.getInstance().marshall(provisioningParameter, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if ((tagsList = provisionProductRequest.getTags()) != null) {
                jsonGenerator.writeFieldName("Tags");
                jsonGenerator.writeStartArray();
                for (Tag tag : tagsList) {
                    if (tag == null) continue;
                    TagJsonMarshaller.getInstance().marshall(tag, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if ((list = provisionProductRequest.getNotificationArns()) != null) {
                jsonGenerator.writeFieldName("NotificationArns");
                jsonGenerator.writeStartArray();
                for (String notificationArnsListValue : list) {
                    if (notificationArnsListValue == null) continue;
                    jsonGenerator.writeValue(notificationArnsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeFieldName("ProvisionToken").writeValue(IdempotentUtils.resolveString((String)provisionProductRequest.getProvisionToken()));
            jsonGenerator.writeEndObject();
            byte[] byArray = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(byArray));
            request.addHeader("Content-Length", Integer.toString(byArray.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

