/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.servermigration.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.servermigration.model.Server;

@SdkInternalApi
public class ServerMarshaller {
    private static final MarshallingInfo<String> SERVERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("serverId").build();
    private static final MarshallingInfo<String> SERVERTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("serverType").build();
    private static final MarshallingInfo<StructuredPojo> VMSERVER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vmServer").build();
    private static final MarshallingInfo<String> REPLICATIONJOBID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("replicationJobId").build();
    private static final MarshallingInfo<Boolean> REPLICATIONJOBTERMINATED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("replicationJobTerminated").build();
    private static final ServerMarshaller instance = new ServerMarshaller();

    public static ServerMarshaller getInstance() {
        return instance;
    }

    public void marshall(Server server, ProtocolMarshaller protocolMarshaller) {
        if (server == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)server.getServerId(), SERVERID_BINDING);
            protocolMarshaller.marshall((Object)server.getServerType(), SERVERTYPE_BINDING);
            protocolMarshaller.marshall((Object)server.getVmServer(), VMSERVER_BINDING);
            protocolMarshaller.marshall((Object)server.getReplicationJobId(), REPLICATIONJOBID_BINDING);
            protocolMarshaller.marshall((Object)server.getReplicationJobTerminated(), REPLICATIONJOBTERMINATED_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

