/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securitylake.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.securitylake.model.AwsIdentity;
import com.amazonaws.services.securitylake.model.LogSourceResource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateSubscriberRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<LogSourceResource> sources;
    private String subscriberDescription;
    private String subscriberId;
    private AwsIdentity subscriberIdentity;
    private String subscriberName;

    public List<LogSourceResource> getSources() {
        return this.sources;
    }

    public void setSources(Collection<LogSourceResource> sources) {
        if (sources == null) {
            this.sources = null;
            return;
        }
        this.sources = new ArrayList<LogSourceResource>(sources);
    }

    public UpdateSubscriberRequest withSources(LogSourceResource ... sources) {
        if (this.sources == null) {
            this.setSources(new ArrayList<LogSourceResource>(sources.length));
        }
        for (LogSourceResource ele : sources) {
            this.sources.add(ele);
        }
        return this;
    }

    public UpdateSubscriberRequest withSources(Collection<LogSourceResource> sources) {
        this.setSources(sources);
        return this;
    }

    public void setSubscriberDescription(String subscriberDescription) {
        this.subscriberDescription = subscriberDescription;
    }

    public String getSubscriberDescription() {
        return this.subscriberDescription;
    }

    public UpdateSubscriberRequest withSubscriberDescription(String subscriberDescription) {
        this.setSubscriberDescription(subscriberDescription);
        return this;
    }

    public void setSubscriberId(String subscriberId) {
        this.subscriberId = subscriberId;
    }

    public String getSubscriberId() {
        return this.subscriberId;
    }

    public UpdateSubscriberRequest withSubscriberId(String subscriberId) {
        this.setSubscriberId(subscriberId);
        return this;
    }

    public void setSubscriberIdentity(AwsIdentity subscriberIdentity) {
        this.subscriberIdentity = subscriberIdentity;
    }

    public AwsIdentity getSubscriberIdentity() {
        return this.subscriberIdentity;
    }

    public UpdateSubscriberRequest withSubscriberIdentity(AwsIdentity subscriberIdentity) {
        this.setSubscriberIdentity(subscriberIdentity);
        return this;
    }

    public void setSubscriberName(String subscriberName) {
        this.subscriberName = subscriberName;
    }

    public String getSubscriberName() {
        return this.subscriberName;
    }

    public UpdateSubscriberRequest withSubscriberName(String subscriberName) {
        this.setSubscriberName(subscriberName);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSources() != null) {
            sb.append("Sources: ").append(this.getSources()).append(",");
        }
        if (this.getSubscriberDescription() != null) {
            sb.append("SubscriberDescription: ").append(this.getSubscriberDescription()).append(",");
        }
        if (this.getSubscriberId() != null) {
            sb.append("SubscriberId: ").append(this.getSubscriberId()).append(",");
        }
        if (this.getSubscriberIdentity() != null) {
            sb.append("SubscriberIdentity: ").append(this.getSubscriberIdentity()).append(",");
        }
        if (this.getSubscriberName() != null) {
            sb.append("SubscriberName: ").append(this.getSubscriberName());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSubscriberRequest)) {
            return false;
        }
        UpdateSubscriberRequest other = (UpdateSubscriberRequest)obj;
        if (other.getSources() == null ^ this.getSources() == null) {
            return false;
        }
        if (other.getSources() != null && !other.getSources().equals(this.getSources())) {
            return false;
        }
        if (other.getSubscriberDescription() == null ^ this.getSubscriberDescription() == null) {
            return false;
        }
        if (other.getSubscriberDescription() != null && !other.getSubscriberDescription().equals(this.getSubscriberDescription())) {
            return false;
        }
        if (other.getSubscriberId() == null ^ this.getSubscriberId() == null) {
            return false;
        }
        if (other.getSubscriberId() != null && !other.getSubscriberId().equals(this.getSubscriberId())) {
            return false;
        }
        if (other.getSubscriberIdentity() == null ^ this.getSubscriberIdentity() == null) {
            return false;
        }
        if (other.getSubscriberIdentity() != null && !other.getSubscriberIdentity().equals(this.getSubscriberIdentity())) {
            return false;
        }
        if (other.getSubscriberName() == null ^ this.getSubscriberName() == null) {
            return false;
        }
        return other.getSubscriberName() == null || other.getSubscriberName().equals(this.getSubscriberName());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSources() == null ? 0 : this.getSources().hashCode());
        hashCode = 31 * hashCode + (this.getSubscriberDescription() == null ? 0 : this.getSubscriberDescription().hashCode());
        hashCode = 31 * hashCode + (this.getSubscriberId() == null ? 0 : this.getSubscriberId().hashCode());
        hashCode = 31 * hashCode + (this.getSubscriberIdentity() == null ? 0 : this.getSubscriberIdentity().hashCode());
        hashCode = 31 * hashCode + (this.getSubscriberName() == null ? 0 : this.getSubscriberName().hashCode());
        return hashCode;
    }

    public UpdateSubscriberRequest clone() {
        return (UpdateSubscriberRequest)super.clone();
    }
}

