/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.securityhub.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.securityhub.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * AwsCodeBuildProjectDetails JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AwsCodeBuildProjectDetailsJsonUnmarshaller implements Unmarshaller<AwsCodeBuildProjectDetails, JsonUnmarshallerContext> {

    public AwsCodeBuildProjectDetails unmarshall(JsonUnmarshallerContext context) throws Exception {
        AwsCodeBuildProjectDetails awsCodeBuildProjectDetails = new AwsCodeBuildProjectDetails();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("EncryptionKey", targetDepth)) {
                    context.nextToken();
                    awsCodeBuildProjectDetails.setEncryptionKey(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Artifacts", targetDepth)) {
                    context.nextToken();
                    awsCodeBuildProjectDetails.setArtifacts(new ListUnmarshaller<AwsCodeBuildProjectArtifactsDetails>(
                            AwsCodeBuildProjectArtifactsDetailsJsonUnmarshaller.getInstance())

                    .unmarshall(context));
                }
                if (context.testExpression("Environment", targetDepth)) {
                    context.nextToken();
                    awsCodeBuildProjectDetails.setEnvironment(AwsCodeBuildProjectEnvironmentJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    awsCodeBuildProjectDetails.setName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Source", targetDepth)) {
                    context.nextToken();
                    awsCodeBuildProjectDetails.setSource(AwsCodeBuildProjectSourceJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("ServiceRole", targetDepth)) {
                    context.nextToken();
                    awsCodeBuildProjectDetails.setServiceRole(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("LogsConfig", targetDepth)) {
                    context.nextToken();
                    awsCodeBuildProjectDetails.setLogsConfig(AwsCodeBuildProjectLogsConfigDetailsJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("VpcConfig", targetDepth)) {
                    context.nextToken();
                    awsCodeBuildProjectDetails.setVpcConfig(AwsCodeBuildProjectVpcConfigJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("SecondaryArtifacts", targetDepth)) {
                    context.nextToken();
                    awsCodeBuildProjectDetails.setSecondaryArtifacts(new ListUnmarshaller<AwsCodeBuildProjectArtifactsDetails>(
                            AwsCodeBuildProjectArtifactsDetailsJsonUnmarshaller.getInstance())

                    .unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return awsCodeBuildProjectDetails;
    }

    private static AwsCodeBuildProjectDetailsJsonUnmarshaller instance;

    public static AwsCodeBuildProjectDetailsJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new AwsCodeBuildProjectDetailsJsonUnmarshaller();
        return instance;
    }
}
