/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.securityhub.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Describes the configuration of scanning EBS volumes (Malware Protection) as a data source.
 * </p>
 * 
 * @see <a
 *      href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/AwsGuardDutyDetectorDataSourcesMalwareProtectionScanEc2InstanceWithFindingsEbsVolumesDetails"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AwsGuardDutyDetectorDataSourcesMalwareProtectionScanEc2InstanceWithFindingsEbsVolumesDetails implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * Specifies the reason why scanning EBS volumes (Malware Protection) isn’t activated as a data source.
     * </p>
     */
    private String reason;
    /**
     * <p>
     * Describes whether scanning EBS volumes is activated as a data source for the detector.
     * </p>
     */
    private String status;

    /**
     * <p>
     * Specifies the reason why scanning EBS volumes (Malware Protection) isn’t activated as a data source.
     * </p>
     * 
     * @param reason
     *        Specifies the reason why scanning EBS volumes (Malware Protection) isn’t activated as a data source.
     */

    public void setReason(String reason) {
        this.reason = reason;
    }

    /**
     * <p>
     * Specifies the reason why scanning EBS volumes (Malware Protection) isn’t activated as a data source.
     * </p>
     * 
     * @return Specifies the reason why scanning EBS volumes (Malware Protection) isn’t activated as a data source.
     */

    public String getReason() {
        return this.reason;
    }

    /**
     * <p>
     * Specifies the reason why scanning EBS volumes (Malware Protection) isn’t activated as a data source.
     * </p>
     * 
     * @param reason
     *        Specifies the reason why scanning EBS volumes (Malware Protection) isn’t activated as a data source.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsGuardDutyDetectorDataSourcesMalwareProtectionScanEc2InstanceWithFindingsEbsVolumesDetails withReason(String reason) {
        setReason(reason);
        return this;
    }

    /**
     * <p>
     * Describes whether scanning EBS volumes is activated as a data source for the detector.
     * </p>
     * 
     * @param status
     *        Describes whether scanning EBS volumes is activated as a data source for the detector.
     */

    public void setStatus(String status) {
        this.status = status;
    }

    /**
     * <p>
     * Describes whether scanning EBS volumes is activated as a data source for the detector.
     * </p>
     * 
     * @return Describes whether scanning EBS volumes is activated as a data source for the detector.
     */

    public String getStatus() {
        return this.status;
    }

    /**
     * <p>
     * Describes whether scanning EBS volumes is activated as a data source for the detector.
     * </p>
     * 
     * @param status
     *        Describes whether scanning EBS volumes is activated as a data source for the detector.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AwsGuardDutyDetectorDataSourcesMalwareProtectionScanEc2InstanceWithFindingsEbsVolumesDetails withStatus(String status) {
        setStatus(status);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getReason() != null)
            sb.append("Reason: ").append(getReason()).append(",");
        if (getStatus() != null)
            sb.append("Status: ").append(getStatus());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof AwsGuardDutyDetectorDataSourcesMalwareProtectionScanEc2InstanceWithFindingsEbsVolumesDetails == false)
            return false;
        AwsGuardDutyDetectorDataSourcesMalwareProtectionScanEc2InstanceWithFindingsEbsVolumesDetails other = (AwsGuardDutyDetectorDataSourcesMalwareProtectionScanEc2InstanceWithFindingsEbsVolumesDetails) obj;
        if (other.getReason() == null ^ this.getReason() == null)
            return false;
        if (other.getReason() != null && other.getReason().equals(this.getReason()) == false)
            return false;
        if (other.getStatus() == null ^ this.getStatus() == null)
            return false;
        if (other.getStatus() != null && other.getStatus().equals(this.getStatus()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getReason() == null) ? 0 : getReason().hashCode());
        hashCode = prime * hashCode + ((getStatus() == null) ? 0 : getStatus().hashCode());
        return hashCode;
    }

    @Override
    public AwsGuardDutyDetectorDataSourcesMalwareProtectionScanEc2InstanceWithFindingsEbsVolumesDetails clone() {
        try {
            return (AwsGuardDutyDetectorDataSourcesMalwareProtectionScanEc2InstanceWithFindingsEbsVolumesDetails) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.securityhub.model.transform.AwsGuardDutyDetectorDataSourcesMalwareProtectionScanEc2InstanceWithFindingsEbsVolumesDetailsMarshaller
                .getInstance().marshall(this, protocolMarshaller);
    }
}
