/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securityhub.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.securityhub.model.Vulnerability;
import java.util.List;

@SdkInternalApi
public class VulnerabilityMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").build();
    private static final MarshallingInfo<List> VULNERABLEPACKAGES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VulnerablePackages").build();
    private static final MarshallingInfo<List> CVSS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Cvss").build();
    private static final MarshallingInfo<List> RELATEDVULNERABILITIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RelatedVulnerabilities").build();
    private static final MarshallingInfo<StructuredPojo> VENDOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Vendor").build();
    private static final MarshallingInfo<List> REFERENCEURLS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReferenceUrls").build();
    private static final MarshallingInfo<String> FIXAVAILABLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FixAvailable").build();
    private static final MarshallingInfo<Double> EPSSSCORE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EpssScore").build();
    private static final MarshallingInfo<String> EXPLOITAVAILABLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExploitAvailable").build();
    private static final MarshallingInfo<String> LASTKNOWNEXPLOITAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastKnownExploitAt").build();
    private static final MarshallingInfo<List> CODEVULNERABILITIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CodeVulnerabilities").build();
    private static final VulnerabilityMarshaller instance = new VulnerabilityMarshaller();

    public static VulnerabilityMarshaller getInstance() {
        return instance;
    }

    public void marshall(Vulnerability vulnerability, ProtocolMarshaller protocolMarshaller) {
        if (vulnerability == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)vulnerability.getId(), ID_BINDING);
            protocolMarshaller.marshall(vulnerability.getVulnerablePackages(), VULNERABLEPACKAGES_BINDING);
            protocolMarshaller.marshall(vulnerability.getCvss(), CVSS_BINDING);
            protocolMarshaller.marshall(vulnerability.getRelatedVulnerabilities(), RELATEDVULNERABILITIES_BINDING);
            protocolMarshaller.marshall((Object)vulnerability.getVendor(), VENDOR_BINDING);
            protocolMarshaller.marshall(vulnerability.getReferenceUrls(), REFERENCEURLS_BINDING);
            protocolMarshaller.marshall((Object)vulnerability.getFixAvailable(), FIXAVAILABLE_BINDING);
            protocolMarshaller.marshall((Object)vulnerability.getEpssScore(), EPSSSCORE_BINDING);
            protocolMarshaller.marshall((Object)vulnerability.getExploitAvailable(), EXPLOITAVAILABLE_BINDING);
            protocolMarshaller.marshall((Object)vulnerability.getLastKnownExploitAt(), LASTKNOWNEXPLOITAT_BINDING);
            protocolMarshaller.marshall(vulnerability.getCodeVulnerabilities(), CODEVULNERABILITIES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

