/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securityhub.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.securityhub.model.AwsSecurityFindingIdentifier;
import com.amazonaws.services.securityhub.model.FindingHistoryUpdate;
import com.amazonaws.services.securityhub.model.FindingHistoryUpdateSource;
import com.amazonaws.services.securityhub.model.transform.FindingHistoryRecordMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class FindingHistoryRecord
implements Serializable,
Cloneable,
StructuredPojo {
    private AwsSecurityFindingIdentifier findingIdentifier;
    private Date updateTime;
    private Boolean findingCreated;
    private FindingHistoryUpdateSource updateSource;
    private List<FindingHistoryUpdate> updates;
    private String nextToken;

    public void setFindingIdentifier(AwsSecurityFindingIdentifier findingIdentifier) {
        this.findingIdentifier = findingIdentifier;
    }

    public AwsSecurityFindingIdentifier getFindingIdentifier() {
        return this.findingIdentifier;
    }

    public FindingHistoryRecord withFindingIdentifier(AwsSecurityFindingIdentifier findingIdentifier) {
        this.setFindingIdentifier(findingIdentifier);
        return this;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public FindingHistoryRecord withUpdateTime(Date updateTime) {
        this.setUpdateTime(updateTime);
        return this;
    }

    public void setFindingCreated(Boolean findingCreated) {
        this.findingCreated = findingCreated;
    }

    public Boolean getFindingCreated() {
        return this.findingCreated;
    }

    public FindingHistoryRecord withFindingCreated(Boolean findingCreated) {
        this.setFindingCreated(findingCreated);
        return this;
    }

    public Boolean isFindingCreated() {
        return this.findingCreated;
    }

    public void setUpdateSource(FindingHistoryUpdateSource updateSource) {
        this.updateSource = updateSource;
    }

    public FindingHistoryUpdateSource getUpdateSource() {
        return this.updateSource;
    }

    public FindingHistoryRecord withUpdateSource(FindingHistoryUpdateSource updateSource) {
        this.setUpdateSource(updateSource);
        return this;
    }

    public List<FindingHistoryUpdate> getUpdates() {
        return this.updates;
    }

    public void setUpdates(Collection<FindingHistoryUpdate> updates) {
        if (updates == null) {
            this.updates = null;
            return;
        }
        this.updates = new ArrayList<FindingHistoryUpdate>(updates);
    }

    public FindingHistoryRecord withUpdates(FindingHistoryUpdate ... updates) {
        if (this.updates == null) {
            this.setUpdates(new ArrayList<FindingHistoryUpdate>(updates.length));
        }
        for (FindingHistoryUpdate ele : updates) {
            this.updates.add(ele);
        }
        return this;
    }

    public FindingHistoryRecord withUpdates(Collection<FindingHistoryUpdate> updates) {
        this.setUpdates(updates);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public FindingHistoryRecord withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFindingIdentifier() != null) {
            sb.append("FindingIdentifier: ").append(this.getFindingIdentifier()).append(",");
        }
        if (this.getUpdateTime() != null) {
            sb.append("UpdateTime: ").append(this.getUpdateTime()).append(",");
        }
        if (this.getFindingCreated() != null) {
            sb.append("FindingCreated: ").append(this.getFindingCreated()).append(",");
        }
        if (this.getUpdateSource() != null) {
            sb.append("UpdateSource: ").append(this.getUpdateSource()).append(",");
        }
        if (this.getUpdates() != null) {
            sb.append("Updates: ").append(this.getUpdates()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FindingHistoryRecord)) {
            return false;
        }
        FindingHistoryRecord other = (FindingHistoryRecord)obj;
        if (other.getFindingIdentifier() == null ^ this.getFindingIdentifier() == null) {
            return false;
        }
        if (other.getFindingIdentifier() != null && !other.getFindingIdentifier().equals(this.getFindingIdentifier())) {
            return false;
        }
        if (other.getUpdateTime() == null ^ this.getUpdateTime() == null) {
            return false;
        }
        if (other.getUpdateTime() != null && !other.getUpdateTime().equals(this.getUpdateTime())) {
            return false;
        }
        if (other.getFindingCreated() == null ^ this.getFindingCreated() == null) {
            return false;
        }
        if (other.getFindingCreated() != null && !other.getFindingCreated().equals(this.getFindingCreated())) {
            return false;
        }
        if (other.getUpdateSource() == null ^ this.getUpdateSource() == null) {
            return false;
        }
        if (other.getUpdateSource() != null && !other.getUpdateSource().equals(this.getUpdateSource())) {
            return false;
        }
        if (other.getUpdates() == null ^ this.getUpdates() == null) {
            return false;
        }
        if (other.getUpdates() != null && !other.getUpdates().equals(this.getUpdates())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFindingIdentifier() == null ? 0 : this.getFindingIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getUpdateTime() == null ? 0 : this.getUpdateTime().hashCode());
        hashCode = 31 * hashCode + (this.getFindingCreated() == null ? 0 : this.getFindingCreated().hashCode());
        hashCode = 31 * hashCode + (this.getUpdateSource() == null ? 0 : this.getUpdateSource().hashCode());
        hashCode = 31 * hashCode + (this.getUpdates() == null ? 0 : this.getUpdates().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public FindingHistoryRecord clone() {
        try {
            return (FindingHistoryRecord)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FindingHistoryRecordMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

