/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.secretsmanager;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.secretsmanager.AWSSecretsManagerAsync;
import com.amazonaws.services.secretsmanager.AWSSecretsManagerAsyncClientBuilder;
import com.amazonaws.services.secretsmanager.AWSSecretsManagerClient;
import com.amazonaws.services.secretsmanager.model.CancelRotateSecretRequest;
import com.amazonaws.services.secretsmanager.model.CancelRotateSecretResult;
import com.amazonaws.services.secretsmanager.model.CreateSecretRequest;
import com.amazonaws.services.secretsmanager.model.CreateSecretResult;
import com.amazonaws.services.secretsmanager.model.DeleteResourcePolicyRequest;
import com.amazonaws.services.secretsmanager.model.DeleteResourcePolicyResult;
import com.amazonaws.services.secretsmanager.model.DeleteSecretRequest;
import com.amazonaws.services.secretsmanager.model.DeleteSecretResult;
import com.amazonaws.services.secretsmanager.model.DescribeSecretRequest;
import com.amazonaws.services.secretsmanager.model.DescribeSecretResult;
import com.amazonaws.services.secretsmanager.model.GetRandomPasswordRequest;
import com.amazonaws.services.secretsmanager.model.GetRandomPasswordResult;
import com.amazonaws.services.secretsmanager.model.GetResourcePolicyRequest;
import com.amazonaws.services.secretsmanager.model.GetResourcePolicyResult;
import com.amazonaws.services.secretsmanager.model.GetSecretValueRequest;
import com.amazonaws.services.secretsmanager.model.GetSecretValueResult;
import com.amazonaws.services.secretsmanager.model.ListSecretVersionIdsRequest;
import com.amazonaws.services.secretsmanager.model.ListSecretVersionIdsResult;
import com.amazonaws.services.secretsmanager.model.ListSecretsRequest;
import com.amazonaws.services.secretsmanager.model.ListSecretsResult;
import com.amazonaws.services.secretsmanager.model.PutResourcePolicyRequest;
import com.amazonaws.services.secretsmanager.model.PutResourcePolicyResult;
import com.amazonaws.services.secretsmanager.model.PutSecretValueRequest;
import com.amazonaws.services.secretsmanager.model.PutSecretValueResult;
import com.amazonaws.services.secretsmanager.model.RestoreSecretRequest;
import com.amazonaws.services.secretsmanager.model.RestoreSecretResult;
import com.amazonaws.services.secretsmanager.model.RotateSecretRequest;
import com.amazonaws.services.secretsmanager.model.RotateSecretResult;
import com.amazonaws.services.secretsmanager.model.TagResourceRequest;
import com.amazonaws.services.secretsmanager.model.TagResourceResult;
import com.amazonaws.services.secretsmanager.model.UntagResourceRequest;
import com.amazonaws.services.secretsmanager.model.UntagResourceResult;
import com.amazonaws.services.secretsmanager.model.UpdateSecretRequest;
import com.amazonaws.services.secretsmanager.model.UpdateSecretResult;
import com.amazonaws.services.secretsmanager.model.UpdateSecretVersionStageRequest;
import com.amazonaws.services.secretsmanager.model.UpdateSecretVersionStageResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSSecretsManagerAsyncClient
extends AWSSecretsManagerClient
implements AWSSecretsManagerAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSSecretsManagerAsyncClientBuilder asyncBuilder() {
        return AWSSecretsManagerAsyncClientBuilder.standard();
    }

    AWSSecretsManagerAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSSecretsManagerAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CancelRotateSecretResult> cancelRotateSecretAsync(CancelRotateSecretRequest request) {
        return this.cancelRotateSecretAsync(request, null);
    }

    @Override
    public Future<CancelRotateSecretResult> cancelRotateSecretAsync(CancelRotateSecretRequest request, final AsyncHandler<CancelRotateSecretRequest, CancelRotateSecretResult> asyncHandler) {
        final CancelRotateSecretRequest finalRequest = (CancelRotateSecretRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CancelRotateSecretResult>(){

            @Override
            public CancelRotateSecretResult call() throws Exception {
                CancelRotateSecretResult result = null;
                try {
                    result = AWSSecretsManagerAsyncClient.this.executeCancelRotateSecret(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateSecretResult> createSecretAsync(CreateSecretRequest request) {
        return this.createSecretAsync(request, null);
    }

    @Override
    public Future<CreateSecretResult> createSecretAsync(CreateSecretRequest request, final AsyncHandler<CreateSecretRequest, CreateSecretResult> asyncHandler) {
        final CreateSecretRequest finalRequest = (CreateSecretRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateSecretResult>(){

            @Override
            public CreateSecretResult call() throws Exception {
                CreateSecretResult result = null;
                try {
                    result = AWSSecretsManagerAsyncClient.this.executeCreateSecret(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteResourcePolicyResult> deleteResourcePolicyAsync(DeleteResourcePolicyRequest request) {
        return this.deleteResourcePolicyAsync(request, null);
    }

    @Override
    public Future<DeleteResourcePolicyResult> deleteResourcePolicyAsync(DeleteResourcePolicyRequest request, final AsyncHandler<DeleteResourcePolicyRequest, DeleteResourcePolicyResult> asyncHandler) {
        final DeleteResourcePolicyRequest finalRequest = (DeleteResourcePolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteResourcePolicyResult>(){

            @Override
            public DeleteResourcePolicyResult call() throws Exception {
                DeleteResourcePolicyResult result = null;
                try {
                    result = AWSSecretsManagerAsyncClient.this.executeDeleteResourcePolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteSecretResult> deleteSecretAsync(DeleteSecretRequest request) {
        return this.deleteSecretAsync(request, null);
    }

    @Override
    public Future<DeleteSecretResult> deleteSecretAsync(DeleteSecretRequest request, final AsyncHandler<DeleteSecretRequest, DeleteSecretResult> asyncHandler) {
        final DeleteSecretRequest finalRequest = (DeleteSecretRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteSecretResult>(){

            @Override
            public DeleteSecretResult call() throws Exception {
                DeleteSecretResult result = null;
                try {
                    result = AWSSecretsManagerAsyncClient.this.executeDeleteSecret(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeSecretResult> describeSecretAsync(DescribeSecretRequest request) {
        return this.describeSecretAsync(request, null);
    }

    @Override
    public Future<DescribeSecretResult> describeSecretAsync(DescribeSecretRequest request, final AsyncHandler<DescribeSecretRequest, DescribeSecretResult> asyncHandler) {
        final DescribeSecretRequest finalRequest = (DescribeSecretRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeSecretResult>(){

            @Override
            public DescribeSecretResult call() throws Exception {
                DescribeSecretResult result = null;
                try {
                    result = AWSSecretsManagerAsyncClient.this.executeDescribeSecret(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetRandomPasswordResult> getRandomPasswordAsync(GetRandomPasswordRequest request) {
        return this.getRandomPasswordAsync(request, null);
    }

    @Override
    public Future<GetRandomPasswordResult> getRandomPasswordAsync(GetRandomPasswordRequest request, final AsyncHandler<GetRandomPasswordRequest, GetRandomPasswordResult> asyncHandler) {
        final GetRandomPasswordRequest finalRequest = (GetRandomPasswordRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetRandomPasswordResult>(){

            @Override
            public GetRandomPasswordResult call() throws Exception {
                GetRandomPasswordResult result = null;
                try {
                    result = AWSSecretsManagerAsyncClient.this.executeGetRandomPassword(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetResourcePolicyResult> getResourcePolicyAsync(GetResourcePolicyRequest request) {
        return this.getResourcePolicyAsync(request, null);
    }

    @Override
    public Future<GetResourcePolicyResult> getResourcePolicyAsync(GetResourcePolicyRequest request, final AsyncHandler<GetResourcePolicyRequest, GetResourcePolicyResult> asyncHandler) {
        final GetResourcePolicyRequest finalRequest = (GetResourcePolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetResourcePolicyResult>(){

            @Override
            public GetResourcePolicyResult call() throws Exception {
                GetResourcePolicyResult result = null;
                try {
                    result = AWSSecretsManagerAsyncClient.this.executeGetResourcePolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSecretValueResult> getSecretValueAsync(GetSecretValueRequest request) {
        return this.getSecretValueAsync(request, null);
    }

    @Override
    public Future<GetSecretValueResult> getSecretValueAsync(GetSecretValueRequest request, final AsyncHandler<GetSecretValueRequest, GetSecretValueResult> asyncHandler) {
        final GetSecretValueRequest finalRequest = (GetSecretValueRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetSecretValueResult>(){

            @Override
            public GetSecretValueResult call() throws Exception {
                GetSecretValueResult result = null;
                try {
                    result = AWSSecretsManagerAsyncClient.this.executeGetSecretValue(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListSecretVersionIdsResult> listSecretVersionIdsAsync(ListSecretVersionIdsRequest request) {
        return this.listSecretVersionIdsAsync(request, null);
    }

    @Override
    public Future<ListSecretVersionIdsResult> listSecretVersionIdsAsync(ListSecretVersionIdsRequest request, final AsyncHandler<ListSecretVersionIdsRequest, ListSecretVersionIdsResult> asyncHandler) {
        final ListSecretVersionIdsRequest finalRequest = (ListSecretVersionIdsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListSecretVersionIdsResult>(){

            @Override
            public ListSecretVersionIdsResult call() throws Exception {
                ListSecretVersionIdsResult result = null;
                try {
                    result = AWSSecretsManagerAsyncClient.this.executeListSecretVersionIds(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListSecretsResult> listSecretsAsync(ListSecretsRequest request) {
        return this.listSecretsAsync(request, null);
    }

    @Override
    public Future<ListSecretsResult> listSecretsAsync(ListSecretsRequest request, final AsyncHandler<ListSecretsRequest, ListSecretsResult> asyncHandler) {
        final ListSecretsRequest finalRequest = (ListSecretsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListSecretsResult>(){

            @Override
            public ListSecretsResult call() throws Exception {
                ListSecretsResult result = null;
                try {
                    result = AWSSecretsManagerAsyncClient.this.executeListSecrets(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutResourcePolicyResult> putResourcePolicyAsync(PutResourcePolicyRequest request) {
        return this.putResourcePolicyAsync(request, null);
    }

    @Override
    public Future<PutResourcePolicyResult> putResourcePolicyAsync(PutResourcePolicyRequest request, final AsyncHandler<PutResourcePolicyRequest, PutResourcePolicyResult> asyncHandler) {
        final PutResourcePolicyRequest finalRequest = (PutResourcePolicyRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutResourcePolicyResult>(){

            @Override
            public PutResourcePolicyResult call() throws Exception {
                PutResourcePolicyResult result = null;
                try {
                    result = AWSSecretsManagerAsyncClient.this.executePutResourcePolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutSecretValueResult> putSecretValueAsync(PutSecretValueRequest request) {
        return this.putSecretValueAsync(request, null);
    }

    @Override
    public Future<PutSecretValueResult> putSecretValueAsync(PutSecretValueRequest request, final AsyncHandler<PutSecretValueRequest, PutSecretValueResult> asyncHandler) {
        final PutSecretValueRequest finalRequest = (PutSecretValueRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutSecretValueResult>(){

            @Override
            public PutSecretValueResult call() throws Exception {
                PutSecretValueResult result = null;
                try {
                    result = AWSSecretsManagerAsyncClient.this.executePutSecretValue(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RestoreSecretResult> restoreSecretAsync(RestoreSecretRequest request) {
        return this.restoreSecretAsync(request, null);
    }

    @Override
    public Future<RestoreSecretResult> restoreSecretAsync(RestoreSecretRequest request, final AsyncHandler<RestoreSecretRequest, RestoreSecretResult> asyncHandler) {
        final RestoreSecretRequest finalRequest = (RestoreSecretRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RestoreSecretResult>(){

            @Override
            public RestoreSecretResult call() throws Exception {
                RestoreSecretResult result = null;
                try {
                    result = AWSSecretsManagerAsyncClient.this.executeRestoreSecret(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RotateSecretResult> rotateSecretAsync(RotateSecretRequest request) {
        return this.rotateSecretAsync(request, null);
    }

    @Override
    public Future<RotateSecretResult> rotateSecretAsync(RotateSecretRequest request, final AsyncHandler<RotateSecretRequest, RotateSecretResult> asyncHandler) {
        final RotateSecretRequest finalRequest = (RotateSecretRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RotateSecretResult>(){

            @Override
            public RotateSecretResult call() throws Exception {
                RotateSecretResult result = null;
                try {
                    result = AWSSecretsManagerAsyncClient.this.executeRotateSecret(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSSecretsManagerAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSSecretsManagerAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateSecretResult> updateSecretAsync(UpdateSecretRequest request) {
        return this.updateSecretAsync(request, null);
    }

    @Override
    public Future<UpdateSecretResult> updateSecretAsync(UpdateSecretRequest request, final AsyncHandler<UpdateSecretRequest, UpdateSecretResult> asyncHandler) {
        final UpdateSecretRequest finalRequest = (UpdateSecretRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateSecretResult>(){

            @Override
            public UpdateSecretResult call() throws Exception {
                UpdateSecretResult result = null;
                try {
                    result = AWSSecretsManagerAsyncClient.this.executeUpdateSecret(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateSecretVersionStageResult> updateSecretVersionStageAsync(UpdateSecretVersionStageRequest request) {
        return this.updateSecretVersionStageAsync(request, null);
    }

    @Override
    public Future<UpdateSecretVersionStageResult> updateSecretVersionStageAsync(UpdateSecretVersionStageRequest request, final AsyncHandler<UpdateSecretVersionStageRequest, UpdateSecretVersionStageResult> asyncHandler) {
        final UpdateSecretVersionStageRequest finalRequest = (UpdateSecretVersionStageRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateSecretVersionStageResult>(){

            @Override
            public UpdateSecretVersionStageResult call() throws Exception {
                UpdateSecretVersionStageResult result = null;
                try {
                    result = AWSSecretsManagerAsyncClient.this.executeUpdateSecretVersionStage(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

