/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.schemas.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.schemas.model.RegistrySummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListRegistriesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String nextToken;
    private List<RegistrySummary> registries;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListRegistriesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<RegistrySummary> getRegistries() {
        return this.registries;
    }

    public void setRegistries(Collection<RegistrySummary> registries) {
        if (registries == null) {
            this.registries = null;
            return;
        }
        this.registries = new ArrayList<RegistrySummary>(registries);
    }

    public ListRegistriesResult withRegistries(RegistrySummary ... registries) {
        if (this.registries == null) {
            this.setRegistries(new ArrayList<RegistrySummary>(registries.length));
        }
        for (RegistrySummary ele : registries) {
            this.registries.add(ele);
        }
        return this;
    }

    public ListRegistriesResult withRegistries(Collection<RegistrySummary> registries) {
        this.setRegistries(registries);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getRegistries() != null) {
            sb.append("Registries: ").append(this.getRegistries());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRegistriesResult)) {
            return false;
        }
        ListRegistriesResult other = (ListRegistriesResult)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getRegistries() == null ^ this.getRegistries() == null) {
            return false;
        }
        return other.getRegistries() == null || other.getRegistries().equals(this.getRegistries());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getRegistries() == null ? 0 : this.getRegistries().hashCode());
        return hashCode;
    }

    public ListRegistriesResult clone() {
        try {
            return (ListRegistriesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

