/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.scheduler;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.scheduler.AmazonScheduler;
import com.amazonaws.services.scheduler.AmazonSchedulerClientBuilder;
import com.amazonaws.services.scheduler.model.AmazonSchedulerException;
import com.amazonaws.services.scheduler.model.CreateScheduleGroupRequest;
import com.amazonaws.services.scheduler.model.CreateScheduleGroupResult;
import com.amazonaws.services.scheduler.model.CreateScheduleRequest;
import com.amazonaws.services.scheduler.model.CreateScheduleResult;
import com.amazonaws.services.scheduler.model.DeleteScheduleGroupRequest;
import com.amazonaws.services.scheduler.model.DeleteScheduleGroupResult;
import com.amazonaws.services.scheduler.model.DeleteScheduleRequest;
import com.amazonaws.services.scheduler.model.DeleteScheduleResult;
import com.amazonaws.services.scheduler.model.GetScheduleGroupRequest;
import com.amazonaws.services.scheduler.model.GetScheduleGroupResult;
import com.amazonaws.services.scheduler.model.GetScheduleRequest;
import com.amazonaws.services.scheduler.model.GetScheduleResult;
import com.amazonaws.services.scheduler.model.ListScheduleGroupsRequest;
import com.amazonaws.services.scheduler.model.ListScheduleGroupsResult;
import com.amazonaws.services.scheduler.model.ListSchedulesRequest;
import com.amazonaws.services.scheduler.model.ListSchedulesResult;
import com.amazonaws.services.scheduler.model.ListTagsForResourceRequest;
import com.amazonaws.services.scheduler.model.ListTagsForResourceResult;
import com.amazonaws.services.scheduler.model.TagResourceRequest;
import com.amazonaws.services.scheduler.model.TagResourceResult;
import com.amazonaws.services.scheduler.model.UntagResourceRequest;
import com.amazonaws.services.scheduler.model.UntagResourceResult;
import com.amazonaws.services.scheduler.model.UpdateScheduleRequest;
import com.amazonaws.services.scheduler.model.UpdateScheduleResult;
import com.amazonaws.services.scheduler.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.scheduler.model.transform.CreateScheduleGroupRequestProtocolMarshaller;
import com.amazonaws.services.scheduler.model.transform.CreateScheduleGroupResultJsonUnmarshaller;
import com.amazonaws.services.scheduler.model.transform.CreateScheduleRequestProtocolMarshaller;
import com.amazonaws.services.scheduler.model.transform.CreateScheduleResultJsonUnmarshaller;
import com.amazonaws.services.scheduler.model.transform.DeleteScheduleGroupRequestProtocolMarshaller;
import com.amazonaws.services.scheduler.model.transform.DeleteScheduleGroupResultJsonUnmarshaller;
import com.amazonaws.services.scheduler.model.transform.DeleteScheduleRequestProtocolMarshaller;
import com.amazonaws.services.scheduler.model.transform.DeleteScheduleResultJsonUnmarshaller;
import com.amazonaws.services.scheduler.model.transform.GetScheduleGroupRequestProtocolMarshaller;
import com.amazonaws.services.scheduler.model.transform.GetScheduleGroupResultJsonUnmarshaller;
import com.amazonaws.services.scheduler.model.transform.GetScheduleRequestProtocolMarshaller;
import com.amazonaws.services.scheduler.model.transform.GetScheduleResultJsonUnmarshaller;
import com.amazonaws.services.scheduler.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.scheduler.model.transform.ListScheduleGroupsRequestProtocolMarshaller;
import com.amazonaws.services.scheduler.model.transform.ListScheduleGroupsResultJsonUnmarshaller;
import com.amazonaws.services.scheduler.model.transform.ListSchedulesRequestProtocolMarshaller;
import com.amazonaws.services.scheduler.model.transform.ListSchedulesResultJsonUnmarshaller;
import com.amazonaws.services.scheduler.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.scheduler.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.scheduler.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.scheduler.model.transform.ServiceQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.scheduler.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.scheduler.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.scheduler.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.scheduler.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.scheduler.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.scheduler.model.transform.UpdateScheduleRequestProtocolMarshaller;
import com.amazonaws.services.scheduler.model.transform.UpdateScheduleResultJsonUnmarshaller;
import com.amazonaws.services.scheduler.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonSchedulerClient
extends AmazonWebServiceClient
implements AmazonScheduler {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonScheduler.class);
    private static final String DEFAULT_SIGNING_NAME = "scheduler";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("application/json").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ThrottlingExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceQuotaExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceQuotaExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AmazonSchedulerException.class));

    public static AmazonSchedulerClientBuilder builder() {
        return AmazonSchedulerClientBuilder.standard();
    }

    AmazonSchedulerClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AmazonSchedulerClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("scheduler.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/scheduler/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/scheduler/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateScheduleResult createSchedule(CreateScheduleRequest request) {
        request = (CreateScheduleRequest)this.beforeClientExecution(request);
        return this.executeCreateSchedule(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateScheduleResult executeCreateSchedule(CreateScheduleRequest createScheduleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createScheduleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateScheduleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateScheduleRequestProtocolMarshaller(protocolFactory).marshall((CreateScheduleRequest)super.beforeMarshalling((AmazonWebServiceRequest)createScheduleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Scheduler");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateSchedule");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateScheduleResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateScheduleResult createScheduleResult = (CreateScheduleResult)response.getAwsResponse();
            return createScheduleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateScheduleGroupResult createScheduleGroup(CreateScheduleGroupRequest request) {
        request = (CreateScheduleGroupRequest)this.beforeClientExecution(request);
        return this.executeCreateScheduleGroup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateScheduleGroupResult executeCreateScheduleGroup(CreateScheduleGroupRequest createScheduleGroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createScheduleGroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateScheduleGroupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateScheduleGroupRequestProtocolMarshaller(protocolFactory).marshall((CreateScheduleGroupRequest)super.beforeMarshalling((AmazonWebServiceRequest)createScheduleGroupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Scheduler");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateScheduleGroup");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateScheduleGroupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateScheduleGroupResult createScheduleGroupResult = (CreateScheduleGroupResult)response.getAwsResponse();
            return createScheduleGroupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteScheduleResult deleteSchedule(DeleteScheduleRequest request) {
        request = (DeleteScheduleRequest)this.beforeClientExecution(request);
        return this.executeDeleteSchedule(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteScheduleResult executeDeleteSchedule(DeleteScheduleRequest deleteScheduleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteScheduleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteScheduleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteScheduleRequestProtocolMarshaller(protocolFactory).marshall((DeleteScheduleRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteScheduleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Scheduler");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteSchedule");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteScheduleResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteScheduleResult deleteScheduleResult = (DeleteScheduleResult)response.getAwsResponse();
            return deleteScheduleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteScheduleGroupResult deleteScheduleGroup(DeleteScheduleGroupRequest request) {
        request = (DeleteScheduleGroupRequest)this.beforeClientExecution(request);
        return this.executeDeleteScheduleGroup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteScheduleGroupResult executeDeleteScheduleGroup(DeleteScheduleGroupRequest deleteScheduleGroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteScheduleGroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteScheduleGroupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteScheduleGroupRequestProtocolMarshaller(protocolFactory).marshall((DeleteScheduleGroupRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteScheduleGroupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Scheduler");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteScheduleGroup");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteScheduleGroupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteScheduleGroupResult deleteScheduleGroupResult = (DeleteScheduleGroupResult)response.getAwsResponse();
            return deleteScheduleGroupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetScheduleResult getSchedule(GetScheduleRequest request) {
        request = (GetScheduleRequest)this.beforeClientExecution(request);
        return this.executeGetSchedule(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetScheduleResult executeGetSchedule(GetScheduleRequest getScheduleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getScheduleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetScheduleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetScheduleRequestProtocolMarshaller(protocolFactory).marshall((GetScheduleRequest)super.beforeMarshalling((AmazonWebServiceRequest)getScheduleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Scheduler");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetSchedule");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetScheduleResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetScheduleResult getScheduleResult = (GetScheduleResult)response.getAwsResponse();
            return getScheduleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetScheduleGroupResult getScheduleGroup(GetScheduleGroupRequest request) {
        request = (GetScheduleGroupRequest)this.beforeClientExecution(request);
        return this.executeGetScheduleGroup(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetScheduleGroupResult executeGetScheduleGroup(GetScheduleGroupRequest getScheduleGroupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getScheduleGroupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetScheduleGroupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetScheduleGroupRequestProtocolMarshaller(protocolFactory).marshall((GetScheduleGroupRequest)super.beforeMarshalling((AmazonWebServiceRequest)getScheduleGroupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Scheduler");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetScheduleGroup");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetScheduleGroupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetScheduleGroupResult getScheduleGroupResult = (GetScheduleGroupResult)response.getAwsResponse();
            return getScheduleGroupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListScheduleGroupsResult listScheduleGroups(ListScheduleGroupsRequest request) {
        request = (ListScheduleGroupsRequest)this.beforeClientExecution(request);
        return this.executeListScheduleGroups(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListScheduleGroupsResult executeListScheduleGroups(ListScheduleGroupsRequest listScheduleGroupsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listScheduleGroupsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListScheduleGroupsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListScheduleGroupsRequestProtocolMarshaller(protocolFactory).marshall((ListScheduleGroupsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listScheduleGroupsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Scheduler");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListScheduleGroups");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListScheduleGroupsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListScheduleGroupsResult listScheduleGroupsResult = (ListScheduleGroupsResult)response.getAwsResponse();
            return listScheduleGroupsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListSchedulesResult listSchedules(ListSchedulesRequest request) {
        request = (ListSchedulesRequest)this.beforeClientExecution(request);
        return this.executeListSchedules(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListSchedulesResult executeListSchedules(ListSchedulesRequest listSchedulesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listSchedulesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListSchedulesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListSchedulesRequestProtocolMarshaller(protocolFactory).marshall((ListSchedulesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listSchedulesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Scheduler");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListSchedules");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListSchedulesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListSchedulesResult listSchedulesResult = (ListSchedulesResult)response.getAwsResponse();
            return listSchedulesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Scheduler");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Scheduler");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Scheduler");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateScheduleResult updateSchedule(UpdateScheduleRequest request) {
        request = (UpdateScheduleRequest)this.beforeClientExecution(request);
        return this.executeUpdateSchedule(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateScheduleResult executeUpdateSchedule(UpdateScheduleRequest updateScheduleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateScheduleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateScheduleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateScheduleRequestProtocolMarshaller(protocolFactory).marshall((UpdateScheduleRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateScheduleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Scheduler");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateSchedule");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateScheduleResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateScheduleResult updateScheduleResult = (UpdateScheduleResult)response.getAwsResponse();
            return updateScheduleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

