/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemakergeospatial.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemakergeospatial.model.LogicalOperator;
import com.amazonaws.services.sagemakergeospatial.model.PropertyFilter;
import com.amazonaws.services.sagemakergeospatial.model.transform.PropertyFiltersMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PropertyFilters
implements Serializable,
Cloneable,
StructuredPojo {
    private String logicalOperator;
    private List<PropertyFilter> properties;

    public void setLogicalOperator(String logicalOperator) {
        this.logicalOperator = logicalOperator;
    }

    public String getLogicalOperator() {
        return this.logicalOperator;
    }

    public PropertyFilters withLogicalOperator(String logicalOperator) {
        this.setLogicalOperator(logicalOperator);
        return this;
    }

    public PropertyFilters withLogicalOperator(LogicalOperator logicalOperator) {
        this.logicalOperator = logicalOperator.toString();
        return this;
    }

    public List<PropertyFilter> getProperties() {
        return this.properties;
    }

    public void setProperties(Collection<PropertyFilter> properties) {
        if (properties == null) {
            this.properties = null;
            return;
        }
        this.properties = new ArrayList<PropertyFilter>(properties);
    }

    public PropertyFilters withProperties(PropertyFilter ... properties) {
        if (this.properties == null) {
            this.setProperties(new ArrayList<PropertyFilter>(properties.length));
        }
        for (PropertyFilter ele : properties) {
            this.properties.add(ele);
        }
        return this;
    }

    public PropertyFilters withProperties(Collection<PropertyFilter> properties) {
        this.setProperties(properties);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLogicalOperator() != null) {
            sb.append("LogicalOperator: ").append(this.getLogicalOperator()).append(",");
        }
        if (this.getProperties() != null) {
            sb.append("Properties: ").append(this.getProperties());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PropertyFilters)) {
            return false;
        }
        PropertyFilters other = (PropertyFilters)obj;
        if (other.getLogicalOperator() == null ^ this.getLogicalOperator() == null) {
            return false;
        }
        if (other.getLogicalOperator() != null && !other.getLogicalOperator().equals(this.getLogicalOperator())) {
            return false;
        }
        if (other.getProperties() == null ^ this.getProperties() == null) {
            return false;
        }
        return other.getProperties() == null || other.getProperties().equals(this.getProperties());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLogicalOperator() == null ? 0 : this.getLogicalOperator().hashCode());
        hashCode = 31 * hashCode + (this.getProperties() == null ? 0 : this.getProperties().hashCode());
        return hashCode;
    }

    public PropertyFilters clone() {
        try {
            return (PropertyFilters)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PropertyFiltersMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

