/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemakergeospatial.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemakergeospatial.model.CustomIndicesInput;
import com.amazonaws.services.sagemakergeospatial.model.transform.BandMathConfigInputMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BandMathConfigInput
implements Serializable,
Cloneable,
StructuredPojo {
    private CustomIndicesInput customIndices;
    private List<String> predefinedIndices;

    public void setCustomIndices(CustomIndicesInput customIndices) {
        this.customIndices = customIndices;
    }

    public CustomIndicesInput getCustomIndices() {
        return this.customIndices;
    }

    public BandMathConfigInput withCustomIndices(CustomIndicesInput customIndices) {
        this.setCustomIndices(customIndices);
        return this;
    }

    public List<String> getPredefinedIndices() {
        return this.predefinedIndices;
    }

    public void setPredefinedIndices(Collection<String> predefinedIndices) {
        if (predefinedIndices == null) {
            this.predefinedIndices = null;
            return;
        }
        this.predefinedIndices = new ArrayList<String>(predefinedIndices);
    }

    public BandMathConfigInput withPredefinedIndices(String ... predefinedIndices) {
        if (this.predefinedIndices == null) {
            this.setPredefinedIndices(new ArrayList<String>(predefinedIndices.length));
        }
        for (String ele : predefinedIndices) {
            this.predefinedIndices.add(ele);
        }
        return this;
    }

    public BandMathConfigInput withPredefinedIndices(Collection<String> predefinedIndices) {
        this.setPredefinedIndices(predefinedIndices);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCustomIndices() != null) {
            sb.append("CustomIndices: ").append(this.getCustomIndices()).append(",");
        }
        if (this.getPredefinedIndices() != null) {
            sb.append("PredefinedIndices: ").append(this.getPredefinedIndices());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BandMathConfigInput)) {
            return false;
        }
        BandMathConfigInput other = (BandMathConfigInput)obj;
        if (other.getCustomIndices() == null ^ this.getCustomIndices() == null) {
            return false;
        }
        if (other.getCustomIndices() != null && !other.getCustomIndices().equals(this.getCustomIndices())) {
            return false;
        }
        if (other.getPredefinedIndices() == null ^ this.getPredefinedIndices() == null) {
            return false;
        }
        return other.getPredefinedIndices() == null || other.getPredefinedIndices().equals(this.getPredefinedIndices());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCustomIndices() == null ? 0 : this.getCustomIndices().hashCode());
        hashCode = 31 * hashCode + (this.getPredefinedIndices() == null ? 0 : this.getPredefinedIndices().hashCode());
        return hashCode;
    }

    public BandMathConfigInput clone() {
        try {
            return (BandMathConfigInput)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BandMathConfigInputMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

