/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemakergeospatial.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemakergeospatial.model.GroupBy;
import com.amazonaws.services.sagemakergeospatial.model.TemporalStatistics;
import com.amazonaws.services.sagemakergeospatial.model.transform.TemporalStatisticsConfigInputMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TemporalStatisticsConfigInput
implements Serializable,
Cloneable,
StructuredPojo {
    private String groupBy;
    private List<String> statistics;
    private List<String> targetBands;

    public void setGroupBy(String groupBy) {
        this.groupBy = groupBy;
    }

    public String getGroupBy() {
        return this.groupBy;
    }

    public TemporalStatisticsConfigInput withGroupBy(String groupBy) {
        this.setGroupBy(groupBy);
        return this;
    }

    public TemporalStatisticsConfigInput withGroupBy(GroupBy groupBy) {
        this.groupBy = groupBy.toString();
        return this;
    }

    public List<String> getStatistics() {
        return this.statistics;
    }

    public void setStatistics(Collection<String> statistics) {
        if (statistics == null) {
            this.statistics = null;
            return;
        }
        this.statistics = new ArrayList<String>(statistics);
    }

    public TemporalStatisticsConfigInput withStatistics(String ... statistics) {
        if (this.statistics == null) {
            this.setStatistics(new ArrayList<String>(statistics.length));
        }
        for (String ele : statistics) {
            this.statistics.add(ele);
        }
        return this;
    }

    public TemporalStatisticsConfigInput withStatistics(Collection<String> statistics) {
        this.setStatistics(statistics);
        return this;
    }

    public TemporalStatisticsConfigInput withStatistics(TemporalStatistics ... statistics) {
        ArrayList<String> statisticsCopy = new ArrayList<String>(statistics.length);
        for (TemporalStatistics value : statistics) {
            statisticsCopy.add(value.toString());
        }
        if (this.getStatistics() == null) {
            this.setStatistics(statisticsCopy);
        } else {
            this.getStatistics().addAll(statisticsCopy);
        }
        return this;
    }

    public List<String> getTargetBands() {
        return this.targetBands;
    }

    public void setTargetBands(Collection<String> targetBands) {
        if (targetBands == null) {
            this.targetBands = null;
            return;
        }
        this.targetBands = new ArrayList<String>(targetBands);
    }

    public TemporalStatisticsConfigInput withTargetBands(String ... targetBands) {
        if (this.targetBands == null) {
            this.setTargetBands(new ArrayList<String>(targetBands.length));
        }
        for (String ele : targetBands) {
            this.targetBands.add(ele);
        }
        return this;
    }

    public TemporalStatisticsConfigInput withTargetBands(Collection<String> targetBands) {
        this.setTargetBands(targetBands);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getGroupBy() != null) {
            sb.append("GroupBy: ").append(this.getGroupBy()).append(",");
        }
        if (this.getStatistics() != null) {
            sb.append("Statistics: ").append(this.getStatistics()).append(",");
        }
        if (this.getTargetBands() != null) {
            sb.append("TargetBands: ").append(this.getTargetBands());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TemporalStatisticsConfigInput)) {
            return false;
        }
        TemporalStatisticsConfigInput other = (TemporalStatisticsConfigInput)obj;
        if (other.getGroupBy() == null ^ this.getGroupBy() == null) {
            return false;
        }
        if (other.getGroupBy() != null && !other.getGroupBy().equals(this.getGroupBy())) {
            return false;
        }
        if (other.getStatistics() == null ^ this.getStatistics() == null) {
            return false;
        }
        if (other.getStatistics() != null && !other.getStatistics().equals(this.getStatistics())) {
            return false;
        }
        if (other.getTargetBands() == null ^ this.getTargetBands() == null) {
            return false;
        }
        return other.getTargetBands() == null || other.getTargetBands().equals(this.getTargetBands());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getGroupBy() == null ? 0 : this.getGroupBy().hashCode());
        hashCode = 31 * hashCode + (this.getStatistics() == null ? 0 : this.getStatistics().hashCode());
        hashCode = 31 * hashCode + (this.getTargetBands() == null ? 0 : this.getTargetBands().hashCode());
        return hashCode;
    }

    public TemporalStatisticsConfigInput clone() {
        try {
            return (TemporalStatisticsConfigInput)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TemporalStatisticsConfigInputMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

