/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemakergeospatial.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemakergeospatial.model.AssetValue;
import com.amazonaws.services.sagemakergeospatial.model.Geometry;
import com.amazonaws.services.sagemakergeospatial.model.Properties;
import com.amazonaws.services.sagemakergeospatial.model.transform.ItemSourceMarshaller;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class ItemSource
implements Serializable,
Cloneable,
StructuredPojo {
    private Map<String, AssetValue> assets;
    private Date dateTime;
    private Geometry geometry;
    private String id;
    private Properties properties;

    public Map<String, AssetValue> getAssets() {
        return this.assets;
    }

    public void setAssets(Map<String, AssetValue> assets) {
        this.assets = assets;
    }

    public ItemSource withAssets(Map<String, AssetValue> assets) {
        this.setAssets(assets);
        return this;
    }

    public ItemSource addAssetsEntry(String key, AssetValue value) {
        if (null == this.assets) {
            this.assets = new HashMap<String, AssetValue>();
        }
        if (this.assets.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.assets.put(key, value);
        return this;
    }

    public ItemSource clearAssetsEntries() {
        this.assets = null;
        return this;
    }

    public void setDateTime(Date dateTime) {
        this.dateTime = dateTime;
    }

    public Date getDateTime() {
        return this.dateTime;
    }

    public ItemSource withDateTime(Date dateTime) {
        this.setDateTime(dateTime);
        return this;
    }

    public void setGeometry(Geometry geometry) {
        this.geometry = geometry;
    }

    public Geometry getGeometry() {
        return this.geometry;
    }

    public ItemSource withGeometry(Geometry geometry) {
        this.setGeometry(geometry);
        return this;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public ItemSource withId(String id) {
        this.setId(id);
        return this;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public ItemSource withProperties(Properties properties) {
        this.setProperties(properties);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAssets() != null) {
            sb.append("Assets: ").append(this.getAssets()).append(",");
        }
        if (this.getDateTime() != null) {
            sb.append("DateTime: ").append(this.getDateTime()).append(",");
        }
        if (this.getGeometry() != null) {
            sb.append("Geometry: ").append(this.getGeometry()).append(",");
        }
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getProperties() != null) {
            sb.append("Properties: ").append(this.getProperties());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ItemSource)) {
            return false;
        }
        ItemSource other = (ItemSource)obj;
        if (other.getAssets() == null ^ this.getAssets() == null) {
            return false;
        }
        if (other.getAssets() != null && !other.getAssets().equals(this.getAssets())) {
            return false;
        }
        if (other.getDateTime() == null ^ this.getDateTime() == null) {
            return false;
        }
        if (other.getDateTime() != null && !other.getDateTime().equals(this.getDateTime())) {
            return false;
        }
        if (other.getGeometry() == null ^ this.getGeometry() == null) {
            return false;
        }
        if (other.getGeometry() != null && !other.getGeometry().equals(this.getGeometry())) {
            return false;
        }
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getProperties() == null ^ this.getProperties() == null) {
            return false;
        }
        return other.getProperties() == null || other.getProperties().equals(this.getProperties());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAssets() == null ? 0 : this.getAssets().hashCode());
        hashCode = 31 * hashCode + (this.getDateTime() == null ? 0 : this.getDateTime().hashCode());
        hashCode = 31 * hashCode + (this.getGeometry() == null ? 0 : this.getGeometry().hashCode());
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getProperties() == null ? 0 : this.getProperties().hashCode());
        return hashCode;
    }

    public ItemSource clone() {
        try {
            return (ItemSource)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ItemSourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

