/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemakergeospatial.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemakergeospatial.model.AlgorithmNameGeoMosaic;
import com.amazonaws.services.sagemakergeospatial.model.transform.GeoMosaicConfigInputMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GeoMosaicConfigInput
implements Serializable,
Cloneable,
StructuredPojo {
    private String algorithmName;
    private List<String> targetBands;

    public void setAlgorithmName(String algorithmName) {
        this.algorithmName = algorithmName;
    }

    public String getAlgorithmName() {
        return this.algorithmName;
    }

    public GeoMosaicConfigInput withAlgorithmName(String algorithmName) {
        this.setAlgorithmName(algorithmName);
        return this;
    }

    public GeoMosaicConfigInput withAlgorithmName(AlgorithmNameGeoMosaic algorithmName) {
        this.algorithmName = algorithmName.toString();
        return this;
    }

    public List<String> getTargetBands() {
        return this.targetBands;
    }

    public void setTargetBands(Collection<String> targetBands) {
        if (targetBands == null) {
            this.targetBands = null;
            return;
        }
        this.targetBands = new ArrayList<String>(targetBands);
    }

    public GeoMosaicConfigInput withTargetBands(String ... targetBands) {
        if (this.targetBands == null) {
            this.setTargetBands(new ArrayList<String>(targetBands.length));
        }
        for (String ele : targetBands) {
            this.targetBands.add(ele);
        }
        return this;
    }

    public GeoMosaicConfigInput withTargetBands(Collection<String> targetBands) {
        this.setTargetBands(targetBands);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAlgorithmName() != null) {
            sb.append("AlgorithmName: ").append(this.getAlgorithmName()).append(",");
        }
        if (this.getTargetBands() != null) {
            sb.append("TargetBands: ").append(this.getTargetBands());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeoMosaicConfigInput)) {
            return false;
        }
        GeoMosaicConfigInput other = (GeoMosaicConfigInput)obj;
        if (other.getAlgorithmName() == null ^ this.getAlgorithmName() == null) {
            return false;
        }
        if (other.getAlgorithmName() != null && !other.getAlgorithmName().equals(this.getAlgorithmName())) {
            return false;
        }
        if (other.getTargetBands() == null ^ this.getTargetBands() == null) {
            return false;
        }
        return other.getTargetBands() == null || other.getTargetBands().equals(this.getTargetBands());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAlgorithmName() == null ? 0 : this.getAlgorithmName().hashCode());
        hashCode = 31 * hashCode + (this.getTargetBands() == null ? 0 : this.getTargetBands().hashCode());
        return hashCode;
    }

    public GeoMosaicConfigInput clone() {
        try {
            return (GeoMosaicConfigInput)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GeoMosaicConfigInputMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

