/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemakeredgemanager.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemakeredgemanager.model.Definition;
import com.amazonaws.services.sagemakeredgemanager.model.DeploymentType;
import com.amazonaws.services.sagemakeredgemanager.model.FailureHandlingPolicy;
import com.amazonaws.services.sagemakeredgemanager.model.transform.EdgeDeploymentMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class EdgeDeployment
implements Serializable,
Cloneable,
StructuredPojo {
    private String deploymentName;
    private String type;
    private String failureHandlingPolicy;
    private List<Definition> definitions;

    public void setDeploymentName(String deploymentName) {
        this.deploymentName = deploymentName;
    }

    public String getDeploymentName() {
        return this.deploymentName;
    }

    public EdgeDeployment withDeploymentName(String deploymentName) {
        this.setDeploymentName(deploymentName);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public EdgeDeployment withType(String type) {
        this.setType(type);
        return this;
    }

    public EdgeDeployment withType(DeploymentType type) {
        this.type = type.toString();
        return this;
    }

    public void setFailureHandlingPolicy(String failureHandlingPolicy) {
        this.failureHandlingPolicy = failureHandlingPolicy;
    }

    public String getFailureHandlingPolicy() {
        return this.failureHandlingPolicy;
    }

    public EdgeDeployment withFailureHandlingPolicy(String failureHandlingPolicy) {
        this.setFailureHandlingPolicy(failureHandlingPolicy);
        return this;
    }

    public EdgeDeployment withFailureHandlingPolicy(FailureHandlingPolicy failureHandlingPolicy) {
        this.failureHandlingPolicy = failureHandlingPolicy.toString();
        return this;
    }

    public List<Definition> getDefinitions() {
        return this.definitions;
    }

    public void setDefinitions(Collection<Definition> definitions) {
        if (definitions == null) {
            this.definitions = null;
            return;
        }
        this.definitions = new ArrayList<Definition>(definitions);
    }

    public EdgeDeployment withDefinitions(Definition ... definitions) {
        if (this.definitions == null) {
            this.setDefinitions(new ArrayList<Definition>(definitions.length));
        }
        for (Definition ele : definitions) {
            this.definitions.add(ele);
        }
        return this;
    }

    public EdgeDeployment withDefinitions(Collection<Definition> definitions) {
        this.setDefinitions(definitions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDeploymentName() != null) {
            sb.append("DeploymentName: ").append(this.getDeploymentName()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getFailureHandlingPolicy() != null) {
            sb.append("FailureHandlingPolicy: ").append(this.getFailureHandlingPolicy()).append(",");
        }
        if (this.getDefinitions() != null) {
            sb.append("Definitions: ").append(this.getDefinitions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EdgeDeployment)) {
            return false;
        }
        EdgeDeployment other = (EdgeDeployment)obj;
        if (other.getDeploymentName() == null ^ this.getDeploymentName() == null) {
            return false;
        }
        if (other.getDeploymentName() != null && !other.getDeploymentName().equals(this.getDeploymentName())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getFailureHandlingPolicy() == null ^ this.getFailureHandlingPolicy() == null) {
            return false;
        }
        if (other.getFailureHandlingPolicy() != null && !other.getFailureHandlingPolicy().equals(this.getFailureHandlingPolicy())) {
            return false;
        }
        if (other.getDefinitions() == null ^ this.getDefinitions() == null) {
            return false;
        }
        return other.getDefinitions() == null || other.getDefinitions().equals(this.getDefinitions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDeploymentName() == null ? 0 : this.getDeploymentName().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getFailureHandlingPolicy() == null ? 0 : this.getFailureHandlingPolicy().hashCode());
        hashCode = 31 * hashCode + (this.getDefinitions() == null ? 0 : this.getDefinitions().hashCode());
        return hashCode;
    }

    public EdgeDeployment clone() {
        try {
            return (EdgeDeployment)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EdgeDeploymentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

