/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemakeredgemanager.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.sagemakeredgemanager.model.Model;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class ModelMarshaller {
    private static final MarshallingInfo<String> MODELNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ModelName").build();
    private static final MarshallingInfo<String> MODELVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ModelVersion").build();
    private static final MarshallingInfo<Date> LATESTSAMPLETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LatestSampleTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> LATESTINFERENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LatestInference").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<List> MODELMETRICS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ModelMetrics").build();
    private static final ModelMarshaller instance = new ModelMarshaller();

    public static ModelMarshaller getInstance() {
        return instance;
    }

    public void marshall(Model model, ProtocolMarshaller protocolMarshaller) {
        if (model == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)model.getModelName(), MODELNAME_BINDING);
            protocolMarshaller.marshall((Object)model.getModelVersion(), MODELVERSION_BINDING);
            protocolMarshaller.marshall((Object)model.getLatestSampleTime(), LATESTSAMPLETIME_BINDING);
            protocolMarshaller.marshall((Object)model.getLatestInference(), LATESTINFERENCE_BINDING);
            protocolMarshaller.marshall(model.getModelMetrics(), MODELMETRICS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

