/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.MetricSpecification;

@SdkInternalApi
public class MetricSpecificationMarshaller {
    private static final MarshallingInfo<StructuredPojo> PREDEFINED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Predefined").build();
    private static final MarshallingInfo<StructuredPojo> CUSTOMIZED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Customized").build();
    private static final MetricSpecificationMarshaller instance = new MetricSpecificationMarshaller();

    public static MetricSpecificationMarshaller getInstance() {
        return instance;
    }

    public void marshall(MetricSpecification metricSpecification, ProtocolMarshaller protocolMarshaller) {
        if (metricSpecification == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)metricSpecification.getPredefined(), PREDEFINED_BINDING);
            protocolMarshaller.marshall((Object)metricSpecification.getCustomized(), CUSTOMIZED_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

