/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.MonitoringDatasetFormat;

@SdkInternalApi
public class MonitoringDatasetFormatMarshaller {
    private static final MarshallingInfo<StructuredPojo> CSV_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Csv").build();
    private static final MarshallingInfo<StructuredPojo> JSON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Json").build();
    private static final MarshallingInfo<StructuredPojo> PARQUET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Parquet").build();
    private static final MonitoringDatasetFormatMarshaller instance = new MonitoringDatasetFormatMarshaller();

    public static MonitoringDatasetFormatMarshaller getInstance() {
        return instance;
    }

    public void marshall(MonitoringDatasetFormat monitoringDatasetFormat, ProtocolMarshaller protocolMarshaller) {
        if (monitoringDatasetFormat == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)monitoringDatasetFormat.getCsv(), CSV_BINDING);
            protocolMarshaller.marshall((Object)monitoringDatasetFormat.getJson(), JSON_BINDING);
            protocolMarshaller.marshall((Object)monitoringDatasetFormat.getParquet(), PARQUET_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

