/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.DataCaptureConfigSummary;
import com.amazonaws.services.sagemaker.model.EndpointStatus;
import com.amazonaws.services.sagemaker.model.MonitoringSchedule;
import com.amazonaws.services.sagemaker.model.ProductionVariantSummary;
import com.amazonaws.services.sagemaker.model.Tag;
import com.amazonaws.services.sagemaker.model.transform.EndpointMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Endpoint
implements Serializable,
Cloneable,
StructuredPojo {
    private String endpointName;
    private String endpointArn;
    private String endpointConfigName;
    private List<ProductionVariantSummary> productionVariants;
    private DataCaptureConfigSummary dataCaptureConfig;
    private String endpointStatus;
    private String failureReason;
    private Date creationTime;
    private Date lastModifiedTime;
    private List<MonitoringSchedule> monitoringSchedules;
    private List<Tag> tags;
    private List<ProductionVariantSummary> shadowProductionVariants;

    public void setEndpointName(String endpointName) {
        this.endpointName = endpointName;
    }

    public String getEndpointName() {
        return this.endpointName;
    }

    public Endpoint withEndpointName(String endpointName) {
        this.setEndpointName(endpointName);
        return this;
    }

    public void setEndpointArn(String endpointArn) {
        this.endpointArn = endpointArn;
    }

    public String getEndpointArn() {
        return this.endpointArn;
    }

    public Endpoint withEndpointArn(String endpointArn) {
        this.setEndpointArn(endpointArn);
        return this;
    }

    public void setEndpointConfigName(String endpointConfigName) {
        this.endpointConfigName = endpointConfigName;
    }

    public String getEndpointConfigName() {
        return this.endpointConfigName;
    }

    public Endpoint withEndpointConfigName(String endpointConfigName) {
        this.setEndpointConfigName(endpointConfigName);
        return this;
    }

    public List<ProductionVariantSummary> getProductionVariants() {
        return this.productionVariants;
    }

    public void setProductionVariants(Collection<ProductionVariantSummary> productionVariants) {
        if (productionVariants == null) {
            this.productionVariants = null;
            return;
        }
        this.productionVariants = new ArrayList<ProductionVariantSummary>(productionVariants);
    }

    public Endpoint withProductionVariants(ProductionVariantSummary ... productionVariants) {
        if (this.productionVariants == null) {
            this.setProductionVariants(new ArrayList<ProductionVariantSummary>(productionVariants.length));
        }
        for (ProductionVariantSummary ele : productionVariants) {
            this.productionVariants.add(ele);
        }
        return this;
    }

    public Endpoint withProductionVariants(Collection<ProductionVariantSummary> productionVariants) {
        this.setProductionVariants(productionVariants);
        return this;
    }

    public void setDataCaptureConfig(DataCaptureConfigSummary dataCaptureConfig) {
        this.dataCaptureConfig = dataCaptureConfig;
    }

    public DataCaptureConfigSummary getDataCaptureConfig() {
        return this.dataCaptureConfig;
    }

    public Endpoint withDataCaptureConfig(DataCaptureConfigSummary dataCaptureConfig) {
        this.setDataCaptureConfig(dataCaptureConfig);
        return this;
    }

    public void setEndpointStatus(String endpointStatus) {
        this.endpointStatus = endpointStatus;
    }

    public String getEndpointStatus() {
        return this.endpointStatus;
    }

    public Endpoint withEndpointStatus(String endpointStatus) {
        this.setEndpointStatus(endpointStatus);
        return this;
    }

    public Endpoint withEndpointStatus(EndpointStatus endpointStatus) {
        this.endpointStatus = endpointStatus.toString();
        return this;
    }

    public void setFailureReason(String failureReason) {
        this.failureReason = failureReason;
    }

    public String getFailureReason() {
        return this.failureReason;
    }

    public Endpoint withFailureReason(String failureReason) {
        this.setFailureReason(failureReason);
        return this;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public Endpoint withCreationTime(Date creationTime) {
        this.setCreationTime(creationTime);
        return this;
    }

    public void setLastModifiedTime(Date lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    public Date getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public Endpoint withLastModifiedTime(Date lastModifiedTime) {
        this.setLastModifiedTime(lastModifiedTime);
        return this;
    }

    public List<MonitoringSchedule> getMonitoringSchedules() {
        return this.monitoringSchedules;
    }

    public void setMonitoringSchedules(Collection<MonitoringSchedule> monitoringSchedules) {
        if (monitoringSchedules == null) {
            this.monitoringSchedules = null;
            return;
        }
        this.monitoringSchedules = new ArrayList<MonitoringSchedule>(monitoringSchedules);
    }

    public Endpoint withMonitoringSchedules(MonitoringSchedule ... monitoringSchedules) {
        if (this.monitoringSchedules == null) {
            this.setMonitoringSchedules(new ArrayList<MonitoringSchedule>(monitoringSchedules.length));
        }
        for (MonitoringSchedule ele : monitoringSchedules) {
            this.monitoringSchedules.add(ele);
        }
        return this;
    }

    public Endpoint withMonitoringSchedules(Collection<MonitoringSchedule> monitoringSchedules) {
        this.setMonitoringSchedules(monitoringSchedules);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public Endpoint withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public Endpoint withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public List<ProductionVariantSummary> getShadowProductionVariants() {
        return this.shadowProductionVariants;
    }

    public void setShadowProductionVariants(Collection<ProductionVariantSummary> shadowProductionVariants) {
        if (shadowProductionVariants == null) {
            this.shadowProductionVariants = null;
            return;
        }
        this.shadowProductionVariants = new ArrayList<ProductionVariantSummary>(shadowProductionVariants);
    }

    public Endpoint withShadowProductionVariants(ProductionVariantSummary ... shadowProductionVariants) {
        if (this.shadowProductionVariants == null) {
            this.setShadowProductionVariants(new ArrayList<ProductionVariantSummary>(shadowProductionVariants.length));
        }
        for (ProductionVariantSummary ele : shadowProductionVariants) {
            this.shadowProductionVariants.add(ele);
        }
        return this;
    }

    public Endpoint withShadowProductionVariants(Collection<ProductionVariantSummary> shadowProductionVariants) {
        this.setShadowProductionVariants(shadowProductionVariants);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEndpointName() != null) {
            sb.append("EndpointName: ").append(this.getEndpointName()).append(",");
        }
        if (this.getEndpointArn() != null) {
            sb.append("EndpointArn: ").append(this.getEndpointArn()).append(",");
        }
        if (this.getEndpointConfigName() != null) {
            sb.append("EndpointConfigName: ").append(this.getEndpointConfigName()).append(",");
        }
        if (this.getProductionVariants() != null) {
            sb.append("ProductionVariants: ").append(this.getProductionVariants()).append(",");
        }
        if (this.getDataCaptureConfig() != null) {
            sb.append("DataCaptureConfig: ").append(this.getDataCaptureConfig()).append(",");
        }
        if (this.getEndpointStatus() != null) {
            sb.append("EndpointStatus: ").append(this.getEndpointStatus()).append(",");
        }
        if (this.getFailureReason() != null) {
            sb.append("FailureReason: ").append(this.getFailureReason()).append(",");
        }
        if (this.getCreationTime() != null) {
            sb.append("CreationTime: ").append(this.getCreationTime()).append(",");
        }
        if (this.getLastModifiedTime() != null) {
            sb.append("LastModifiedTime: ").append(this.getLastModifiedTime()).append(",");
        }
        if (this.getMonitoringSchedules() != null) {
            sb.append("MonitoringSchedules: ").append(this.getMonitoringSchedules()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getShadowProductionVariants() != null) {
            sb.append("ShadowProductionVariants: ").append(this.getShadowProductionVariants());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Endpoint)) {
            return false;
        }
        Endpoint other = (Endpoint)obj;
        if (other.getEndpointName() == null ^ this.getEndpointName() == null) {
            return false;
        }
        if (other.getEndpointName() != null && !other.getEndpointName().equals(this.getEndpointName())) {
            return false;
        }
        if (other.getEndpointArn() == null ^ this.getEndpointArn() == null) {
            return false;
        }
        if (other.getEndpointArn() != null && !other.getEndpointArn().equals(this.getEndpointArn())) {
            return false;
        }
        if (other.getEndpointConfigName() == null ^ this.getEndpointConfigName() == null) {
            return false;
        }
        if (other.getEndpointConfigName() != null && !other.getEndpointConfigName().equals(this.getEndpointConfigName())) {
            return false;
        }
        if (other.getProductionVariants() == null ^ this.getProductionVariants() == null) {
            return false;
        }
        if (other.getProductionVariants() != null && !other.getProductionVariants().equals(this.getProductionVariants())) {
            return false;
        }
        if (other.getDataCaptureConfig() == null ^ this.getDataCaptureConfig() == null) {
            return false;
        }
        if (other.getDataCaptureConfig() != null && !other.getDataCaptureConfig().equals(this.getDataCaptureConfig())) {
            return false;
        }
        if (other.getEndpointStatus() == null ^ this.getEndpointStatus() == null) {
            return false;
        }
        if (other.getEndpointStatus() != null && !other.getEndpointStatus().equals(this.getEndpointStatus())) {
            return false;
        }
        if (other.getFailureReason() == null ^ this.getFailureReason() == null) {
            return false;
        }
        if (other.getFailureReason() != null && !other.getFailureReason().equals(this.getFailureReason())) {
            return false;
        }
        if (other.getCreationTime() == null ^ this.getCreationTime() == null) {
            return false;
        }
        if (other.getCreationTime() != null && !other.getCreationTime().equals(this.getCreationTime())) {
            return false;
        }
        if (other.getLastModifiedTime() == null ^ this.getLastModifiedTime() == null) {
            return false;
        }
        if (other.getLastModifiedTime() != null && !other.getLastModifiedTime().equals(this.getLastModifiedTime())) {
            return false;
        }
        if (other.getMonitoringSchedules() == null ^ this.getMonitoringSchedules() == null) {
            return false;
        }
        if (other.getMonitoringSchedules() != null && !other.getMonitoringSchedules().equals(this.getMonitoringSchedules())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getShadowProductionVariants() == null ^ this.getShadowProductionVariants() == null) {
            return false;
        }
        return other.getShadowProductionVariants() == null || other.getShadowProductionVariants().equals(this.getShadowProductionVariants());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEndpointName() == null ? 0 : this.getEndpointName().hashCode());
        hashCode = 31 * hashCode + (this.getEndpointArn() == null ? 0 : this.getEndpointArn().hashCode());
        hashCode = 31 * hashCode + (this.getEndpointConfigName() == null ? 0 : this.getEndpointConfigName().hashCode());
        hashCode = 31 * hashCode + (this.getProductionVariants() == null ? 0 : this.getProductionVariants().hashCode());
        hashCode = 31 * hashCode + (this.getDataCaptureConfig() == null ? 0 : this.getDataCaptureConfig().hashCode());
        hashCode = 31 * hashCode + (this.getEndpointStatus() == null ? 0 : this.getEndpointStatus().hashCode());
        hashCode = 31 * hashCode + (this.getFailureReason() == null ? 0 : this.getFailureReason().hashCode());
        hashCode = 31 * hashCode + (this.getCreationTime() == null ? 0 : this.getCreationTime().hashCode());
        hashCode = 31 * hashCode + (this.getLastModifiedTime() == null ? 0 : this.getLastModifiedTime().hashCode());
        hashCode = 31 * hashCode + (this.getMonitoringSchedules() == null ? 0 : this.getMonitoringSchedules().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getShadowProductionVariants() == null ? 0 : this.getShadowProductionVariants().hashCode());
        return hashCode;
    }

    public Endpoint clone() {
        try {
            return (Endpoint)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EndpointMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

