/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.ProcessingInstanceType;
import com.amazonaws.services.sagemaker.model.transform.ProfilerRuleConfigurationMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ProfilerRuleConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String ruleConfigurationName;
    private String localPath;
    private String s3OutputPath;
    private String ruleEvaluatorImage;
    private String instanceType;
    private Integer volumeSizeInGB;
    private Map<String, String> ruleParameters;

    public void setRuleConfigurationName(String ruleConfigurationName) {
        this.ruleConfigurationName = ruleConfigurationName;
    }

    public String getRuleConfigurationName() {
        return this.ruleConfigurationName;
    }

    public ProfilerRuleConfiguration withRuleConfigurationName(String ruleConfigurationName) {
        this.setRuleConfigurationName(ruleConfigurationName);
        return this;
    }

    public void setLocalPath(String localPath) {
        this.localPath = localPath;
    }

    public String getLocalPath() {
        return this.localPath;
    }

    public ProfilerRuleConfiguration withLocalPath(String localPath) {
        this.setLocalPath(localPath);
        return this;
    }

    public void setS3OutputPath(String s3OutputPath) {
        this.s3OutputPath = s3OutputPath;
    }

    public String getS3OutputPath() {
        return this.s3OutputPath;
    }

    public ProfilerRuleConfiguration withS3OutputPath(String s3OutputPath) {
        this.setS3OutputPath(s3OutputPath);
        return this;
    }

    public void setRuleEvaluatorImage(String ruleEvaluatorImage) {
        this.ruleEvaluatorImage = ruleEvaluatorImage;
    }

    public String getRuleEvaluatorImage() {
        return this.ruleEvaluatorImage;
    }

    public ProfilerRuleConfiguration withRuleEvaluatorImage(String ruleEvaluatorImage) {
        this.setRuleEvaluatorImage(ruleEvaluatorImage);
        return this;
    }

    public void setInstanceType(String instanceType) {
        this.instanceType = instanceType;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public ProfilerRuleConfiguration withInstanceType(String instanceType) {
        this.setInstanceType(instanceType);
        return this;
    }

    public ProfilerRuleConfiguration withInstanceType(ProcessingInstanceType instanceType) {
        this.instanceType = instanceType.toString();
        return this;
    }

    public void setVolumeSizeInGB(Integer volumeSizeInGB) {
        this.volumeSizeInGB = volumeSizeInGB;
    }

    public Integer getVolumeSizeInGB() {
        return this.volumeSizeInGB;
    }

    public ProfilerRuleConfiguration withVolumeSizeInGB(Integer volumeSizeInGB) {
        this.setVolumeSizeInGB(volumeSizeInGB);
        return this;
    }

    public Map<String, String> getRuleParameters() {
        return this.ruleParameters;
    }

    public void setRuleParameters(Map<String, String> ruleParameters) {
        this.ruleParameters = ruleParameters;
    }

    public ProfilerRuleConfiguration withRuleParameters(Map<String, String> ruleParameters) {
        this.setRuleParameters(ruleParameters);
        return this;
    }

    public ProfilerRuleConfiguration addRuleParametersEntry(String key, String value) {
        if (null == this.ruleParameters) {
            this.ruleParameters = new HashMap<String, String>();
        }
        if (this.ruleParameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.ruleParameters.put(key, value);
        return this;
    }

    public ProfilerRuleConfiguration clearRuleParametersEntries() {
        this.ruleParameters = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRuleConfigurationName() != null) {
            sb.append("RuleConfigurationName: ").append(this.getRuleConfigurationName()).append(",");
        }
        if (this.getLocalPath() != null) {
            sb.append("LocalPath: ").append(this.getLocalPath()).append(",");
        }
        if (this.getS3OutputPath() != null) {
            sb.append("S3OutputPath: ").append(this.getS3OutputPath()).append(",");
        }
        if (this.getRuleEvaluatorImage() != null) {
            sb.append("RuleEvaluatorImage: ").append(this.getRuleEvaluatorImage()).append(",");
        }
        if (this.getInstanceType() != null) {
            sb.append("InstanceType: ").append(this.getInstanceType()).append(",");
        }
        if (this.getVolumeSizeInGB() != null) {
            sb.append("VolumeSizeInGB: ").append(this.getVolumeSizeInGB()).append(",");
        }
        if (this.getRuleParameters() != null) {
            sb.append("RuleParameters: ").append(this.getRuleParameters());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProfilerRuleConfiguration)) {
            return false;
        }
        ProfilerRuleConfiguration other = (ProfilerRuleConfiguration)obj;
        if (other.getRuleConfigurationName() == null ^ this.getRuleConfigurationName() == null) {
            return false;
        }
        if (other.getRuleConfigurationName() != null && !other.getRuleConfigurationName().equals(this.getRuleConfigurationName())) {
            return false;
        }
        if (other.getLocalPath() == null ^ this.getLocalPath() == null) {
            return false;
        }
        if (other.getLocalPath() != null && !other.getLocalPath().equals(this.getLocalPath())) {
            return false;
        }
        if (other.getS3OutputPath() == null ^ this.getS3OutputPath() == null) {
            return false;
        }
        if (other.getS3OutputPath() != null && !other.getS3OutputPath().equals(this.getS3OutputPath())) {
            return false;
        }
        if (other.getRuleEvaluatorImage() == null ^ this.getRuleEvaluatorImage() == null) {
            return false;
        }
        if (other.getRuleEvaluatorImage() != null && !other.getRuleEvaluatorImage().equals(this.getRuleEvaluatorImage())) {
            return false;
        }
        if (other.getInstanceType() == null ^ this.getInstanceType() == null) {
            return false;
        }
        if (other.getInstanceType() != null && !other.getInstanceType().equals(this.getInstanceType())) {
            return false;
        }
        if (other.getVolumeSizeInGB() == null ^ this.getVolumeSizeInGB() == null) {
            return false;
        }
        if (other.getVolumeSizeInGB() != null && !other.getVolumeSizeInGB().equals(this.getVolumeSizeInGB())) {
            return false;
        }
        if (other.getRuleParameters() == null ^ this.getRuleParameters() == null) {
            return false;
        }
        return other.getRuleParameters() == null || other.getRuleParameters().equals(this.getRuleParameters());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRuleConfigurationName() == null ? 0 : this.getRuleConfigurationName().hashCode());
        hashCode = 31 * hashCode + (this.getLocalPath() == null ? 0 : this.getLocalPath().hashCode());
        hashCode = 31 * hashCode + (this.getS3OutputPath() == null ? 0 : this.getS3OutputPath().hashCode());
        hashCode = 31 * hashCode + (this.getRuleEvaluatorImage() == null ? 0 : this.getRuleEvaluatorImage().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceType() == null ? 0 : this.getInstanceType().hashCode());
        hashCode = 31 * hashCode + (this.getVolumeSizeInGB() == null ? 0 : this.getVolumeSizeInGB().hashCode());
        hashCode = 31 * hashCode + (this.getRuleParameters() == null ? 0 : this.getRuleParameters().hashCode());
        return hashCode;
    }

    public ProfilerRuleConfiguration clone() {
        try {
            return (ProfilerRuleConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProfilerRuleConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

