/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.CodeRepository;
import com.amazonaws.services.sagemaker.model.ResourceSpec;
import com.amazonaws.services.sagemaker.model.transform.JupyterServerAppSettingsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class JupyterServerAppSettings
implements Serializable,
Cloneable,
StructuredPojo {
    private ResourceSpec defaultResourceSpec;
    private List<String> lifecycleConfigArns;
    private List<CodeRepository> codeRepositories;

    public void setDefaultResourceSpec(ResourceSpec defaultResourceSpec) {
        this.defaultResourceSpec = defaultResourceSpec;
    }

    public ResourceSpec getDefaultResourceSpec() {
        return this.defaultResourceSpec;
    }

    public JupyterServerAppSettings withDefaultResourceSpec(ResourceSpec defaultResourceSpec) {
        this.setDefaultResourceSpec(defaultResourceSpec);
        return this;
    }

    public List<String> getLifecycleConfigArns() {
        return this.lifecycleConfigArns;
    }

    public void setLifecycleConfigArns(Collection<String> lifecycleConfigArns) {
        if (lifecycleConfigArns == null) {
            this.lifecycleConfigArns = null;
            return;
        }
        this.lifecycleConfigArns = new ArrayList<String>(lifecycleConfigArns);
    }

    public JupyterServerAppSettings withLifecycleConfigArns(String ... lifecycleConfigArns) {
        if (this.lifecycleConfigArns == null) {
            this.setLifecycleConfigArns(new ArrayList<String>(lifecycleConfigArns.length));
        }
        for (String ele : lifecycleConfigArns) {
            this.lifecycleConfigArns.add(ele);
        }
        return this;
    }

    public JupyterServerAppSettings withLifecycleConfigArns(Collection<String> lifecycleConfigArns) {
        this.setLifecycleConfigArns(lifecycleConfigArns);
        return this;
    }

    public List<CodeRepository> getCodeRepositories() {
        return this.codeRepositories;
    }

    public void setCodeRepositories(Collection<CodeRepository> codeRepositories) {
        if (codeRepositories == null) {
            this.codeRepositories = null;
            return;
        }
        this.codeRepositories = new ArrayList<CodeRepository>(codeRepositories);
    }

    public JupyterServerAppSettings withCodeRepositories(CodeRepository ... codeRepositories) {
        if (this.codeRepositories == null) {
            this.setCodeRepositories(new ArrayList<CodeRepository>(codeRepositories.length));
        }
        for (CodeRepository ele : codeRepositories) {
            this.codeRepositories.add(ele);
        }
        return this;
    }

    public JupyterServerAppSettings withCodeRepositories(Collection<CodeRepository> codeRepositories) {
        this.setCodeRepositories(codeRepositories);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDefaultResourceSpec() != null) {
            sb.append("DefaultResourceSpec: ").append(this.getDefaultResourceSpec()).append(",");
        }
        if (this.getLifecycleConfigArns() != null) {
            sb.append("LifecycleConfigArns: ").append(this.getLifecycleConfigArns()).append(",");
        }
        if (this.getCodeRepositories() != null) {
            sb.append("CodeRepositories: ").append(this.getCodeRepositories());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JupyterServerAppSettings)) {
            return false;
        }
        JupyterServerAppSettings other = (JupyterServerAppSettings)obj;
        if (other.getDefaultResourceSpec() == null ^ this.getDefaultResourceSpec() == null) {
            return false;
        }
        if (other.getDefaultResourceSpec() != null && !other.getDefaultResourceSpec().equals(this.getDefaultResourceSpec())) {
            return false;
        }
        if (other.getLifecycleConfigArns() == null ^ this.getLifecycleConfigArns() == null) {
            return false;
        }
        if (other.getLifecycleConfigArns() != null && !other.getLifecycleConfigArns().equals(this.getLifecycleConfigArns())) {
            return false;
        }
        if (other.getCodeRepositories() == null ^ this.getCodeRepositories() == null) {
            return false;
        }
        return other.getCodeRepositories() == null || other.getCodeRepositories().equals(this.getCodeRepositories());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDefaultResourceSpec() == null ? 0 : this.getDefaultResourceSpec().hashCode());
        hashCode = 31 * hashCode + (this.getLifecycleConfigArns() == null ? 0 : this.getLifecycleConfigArns().hashCode());
        hashCode = 31 * hashCode + (this.getCodeRepositories() == null ? 0 : this.getCodeRepositories().hashCode());
        return hashCode;
    }

    public JupyterServerAppSettings clone() {
        try {
            return (JupyterServerAppSettings)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        JupyterServerAppSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

