/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.services.s3control.model.S3ObjectMetadata;
import com.amazonaws.transform.MapEntry;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.Map;
import javax.xml.stream.events.XMLEvent;

public class S3ObjectMetadataStaxUnmarshaller
implements Unmarshaller<S3ObjectMetadata, StaxUnmarshallerContext> {
    private static S3ObjectMetadataStaxUnmarshaller instance;

    public S3ObjectMetadata unmarshall(StaxUnmarshallerContext context) throws Exception {
        S3ObjectMetadata s3ObjectMetadata = new S3ObjectMetadata();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return s3ObjectMetadata;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("CacheControl", targetDepth)) {
                    s3ObjectMetadata.setCacheControl(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ContentDisposition", targetDepth)) {
                    s3ObjectMetadata.setContentDisposition(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ContentEncoding", targetDepth)) {
                    s3ObjectMetadata.setContentEncoding(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ContentLanguage", targetDepth)) {
                    s3ObjectMetadata.setContentLanguage(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("UserMetadata/entry", targetDepth)) {
                    Map.Entry<String, String> entry = UserMetadataMapEntryUnmarshaller.getInstance().unmarshall(context);
                    s3ObjectMetadata.addUserMetadataEntry(entry.getKey(), entry.getValue());
                    continue;
                }
                if (context.testExpression("ContentLength", targetDepth)) {
                    s3ObjectMetadata.setContentLength(SimpleTypeStaxUnmarshallers.LongStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ContentMD5", targetDepth)) {
                    s3ObjectMetadata.setContentMD5(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ContentType", targetDepth)) {
                    s3ObjectMetadata.setContentType(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("HttpExpiresDate", targetDepth)) {
                    s3ObjectMetadata.setHttpExpiresDate(SimpleTypeStaxUnmarshallers.DateStaxUnmarshallerFactory.getInstance((String)"iso8601").unmarshall(context));
                    continue;
                }
                if (context.testExpression("RequesterCharged", targetDepth)) {
                    s3ObjectMetadata.setRequesterCharged(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("SSEAlgorithm", targetDepth)) continue;
                s3ObjectMetadata.setSSEAlgorithm(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return s3ObjectMetadata;
    }

    public static S3ObjectMetadataStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new S3ObjectMetadataStaxUnmarshaller();
        }
        return instance;
    }

    private static class UserMetadataMapEntryUnmarshaller
    implements Unmarshaller<Map.Entry<String, String>, StaxUnmarshallerContext> {
        private static UserMetadataMapEntryUnmarshaller instance;

        private UserMetadataMapEntryUnmarshaller() {
        }

        public Map.Entry<String, String> unmarshall(StaxUnmarshallerContext context) throws Exception {
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            MapEntry entry = new MapEntry();
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    return entry;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("key", targetDepth)) {
                        entry.setKey((Object)SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("value", targetDepth)) continue;
                    entry.setValue((Object)SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            return entry;
        }

        public static UserMetadataMapEntryUnmarshaller getInstance() {
            if (instance == null) {
                instance = new UserMetadataMapEntryUnmarshaller();
            }
            return instance;
        }
    }
}

