/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.s3control.model.GetDataAccessRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class GetDataAccessRequestMarshaller
implements Marshaller<Request<GetDataAccessRequest>, GetDataAccessRequest> {
    public Request<GetDataAccessRequest> marshall(GetDataAccessRequest getDataAccessRequest) {
        if (getDataAccessRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getDataAccessRequest, "AWSS3Control");
        request.setHttpMethod(HttpMethodName.GET);
        if (getDataAccessRequest.getAccountId() != null) {
            request.addHeader("x-amz-account-id", StringUtils.fromString((String)getDataAccessRequest.getAccountId()));
        }
        String uriResourcePath = "/v20180820/accessgrantsinstance/dataaccess";
        request.setResourcePath(uriResourcePath);
        if (getDataAccessRequest.getTarget() != null) {
            request.addParameter("target", StringUtils.fromString((String)getDataAccessRequest.getTarget()));
        }
        if (getDataAccessRequest.getPermission() != null) {
            request.addParameter("permission", StringUtils.fromString((String)getDataAccessRequest.getPermission()));
        }
        if (getDataAccessRequest.getDurationSeconds() != null) {
            request.addParameter("durationSeconds", StringUtils.fromInteger((Integer)getDataAccessRequest.getDurationSeconds()));
        }
        if (getDataAccessRequest.getPrivilege() != null) {
            request.addParameter("privilege", StringUtils.fromString((String)getDataAccessRequest.getPrivilege()));
        }
        if (getDataAccessRequest.getTargetType() != null) {
            request.addParameter("targetType", StringUtils.fromString((String)getDataAccessRequest.getTargetType()));
        }
        return request;
    }
}

