/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.s3control.model.AccountLevel;
import com.amazonaws.services.s3control.model.ActivityMetrics;
import com.amazonaws.services.s3control.model.AdvancedCostOptimizationMetrics;
import com.amazonaws.services.s3control.model.AdvancedDataProtectionMetrics;
import com.amazonaws.services.s3control.model.BucketLevel;
import com.amazonaws.services.s3control.model.CloudWatchMetrics;
import com.amazonaws.services.s3control.model.DetailedStatusCodesMetrics;
import com.amazonaws.services.s3control.model.Exclude;
import com.amazonaws.services.s3control.model.Include;
import com.amazonaws.services.s3control.model.PrefixLevel;
import com.amazonaws.services.s3control.model.PrefixLevelStorageMetrics;
import com.amazonaws.services.s3control.model.PutStorageLensConfigurationRequest;
import com.amazonaws.services.s3control.model.S3BucketDestination;
import com.amazonaws.services.s3control.model.SSEKMS;
import com.amazonaws.services.s3control.model.SSES3;
import com.amazonaws.services.s3control.model.SelectionCriteria;
import com.amazonaws.services.s3control.model.StorageLensAwsOrg;
import com.amazonaws.services.s3control.model.StorageLensConfiguration;
import com.amazonaws.services.s3control.model.StorageLensDataExport;
import com.amazonaws.services.s3control.model.StorageLensDataExportEncryption;
import com.amazonaws.services.s3control.model.StorageLensGroupLevel;
import com.amazonaws.services.s3control.model.StorageLensGroupLevelSelectionCriteria;
import com.amazonaws.services.s3control.model.StorageLensTag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.XMLWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;

public class PutStorageLensConfigurationRequestMarshaller
implements Marshaller<Request<PutStorageLensConfigurationRequest>, PutStorageLensConfigurationRequest> {
    public Request<PutStorageLensConfigurationRequest> marshall(PutStorageLensConfigurationRequest putStorageLensConfigurationRequest) {
        if (putStorageLensConfigurationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putStorageLensConfigurationRequest, "AWSS3Control");
        request.setHttpMethod(HttpMethodName.PUT);
        if (putStorageLensConfigurationRequest.getAccountId() != null) {
            request.addHeader("x-amz-account-id", StringUtils.fromString((String)putStorageLensConfigurationRequest.getAccountId()));
        }
        String uriResourcePath = "/v20180820/storagelens/{storagelensid}";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "storagelensid", putStorageLensConfigurationRequest.getConfigId());
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter((Writer)stringWriter, "http://awss3control.amazonaws.com/doc/2018-08-20/");
            xmlWriter.startElement("PutStorageLensConfigurationRequest");
            if (putStorageLensConfigurationRequest != null) {
                List<StorageLensTag> putStorageLensConfigurationRequestTagsList;
                StorageLensConfiguration storageLensConfiguration = putStorageLensConfigurationRequest.getStorageLensConfiguration();
                if (storageLensConfiguration != null) {
                    StorageLensAwsOrg awsOrg;
                    StorageLensDataExport dataExport;
                    Exclude exclude;
                    Include include;
                    AccountLevel accountLevel;
                    xmlWriter.startElement("StorageLensConfiguration");
                    if (storageLensConfiguration.getId() != null) {
                        xmlWriter.startElement("Id").value(storageLensConfiguration.getId()).endElement();
                    }
                    if ((accountLevel = storageLensConfiguration.getAccountLevel()) != null) {
                        StorageLensGroupLevel storageLensGroupLevel;
                        DetailedStatusCodesMetrics detailedStatusCodesMetrics;
                        AdvancedDataProtectionMetrics advancedDataProtectionMetrics;
                        AdvancedCostOptimizationMetrics advancedCostOptimizationMetrics;
                        BucketLevel bucketLevel;
                        xmlWriter.startElement("AccountLevel");
                        ActivityMetrics activityMetrics = accountLevel.getActivityMetrics();
                        if (activityMetrics != null) {
                            xmlWriter.startElement("ActivityMetrics");
                            if (activityMetrics.getIsEnabled() != null) {
                                xmlWriter.startElement("IsEnabled").value((Object)activityMetrics.getIsEnabled()).endElement();
                            }
                            xmlWriter.endElement();
                        }
                        if ((bucketLevel = accountLevel.getBucketLevel()) != null) {
                            DetailedStatusCodesMetrics detailedStatusCodesMetrics2;
                            AdvancedDataProtectionMetrics advancedDataProtectionMetrics2;
                            AdvancedCostOptimizationMetrics advancedCostOptimizationMetrics2;
                            PrefixLevel prefixLevel;
                            xmlWriter.startElement("BucketLevel");
                            ActivityMetrics activityMetrics2 = bucketLevel.getActivityMetrics();
                            if (activityMetrics2 != null) {
                                xmlWriter.startElement("ActivityMetrics");
                                if (activityMetrics2.getIsEnabled() != null) {
                                    xmlWriter.startElement("IsEnabled").value((Object)activityMetrics2.getIsEnabled()).endElement();
                                }
                                xmlWriter.endElement();
                            }
                            if ((prefixLevel = bucketLevel.getPrefixLevel()) != null) {
                                xmlWriter.startElement("PrefixLevel");
                                PrefixLevelStorageMetrics prefixLevelStorageMetrics = prefixLevel.getStorageMetrics();
                                if (prefixLevelStorageMetrics != null) {
                                    Object selectionCriteria;
                                    xmlWriter.startElement("StorageMetrics");
                                    if (prefixLevelStorageMetrics.getIsEnabled() != null) {
                                        xmlWriter.startElement("IsEnabled").value((Object)prefixLevelStorageMetrics.getIsEnabled()).endElement();
                                    }
                                    if ((selectionCriteria = prefixLevelStorageMetrics.getSelectionCriteria()) != null) {
                                        xmlWriter.startElement("SelectionCriteria");
                                        if (((SelectionCriteria)selectionCriteria).getDelimiter() != null) {
                                            xmlWriter.startElement("Delimiter").value(((SelectionCriteria)selectionCriteria).getDelimiter()).endElement();
                                        }
                                        if (((SelectionCriteria)selectionCriteria).getMaxDepth() != null) {
                                            xmlWriter.startElement("MaxDepth").value((Object)((SelectionCriteria)selectionCriteria).getMaxDepth()).endElement();
                                        }
                                        if (((SelectionCriteria)selectionCriteria).getMinStorageBytesPercentage() != null) {
                                            xmlWriter.startElement("MinStorageBytesPercentage").value((Object)((SelectionCriteria)selectionCriteria).getMinStorageBytesPercentage()).endElement();
                                        }
                                        xmlWriter.endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            if ((advancedCostOptimizationMetrics2 = bucketLevel.getAdvancedCostOptimizationMetrics()) != null) {
                                xmlWriter.startElement("AdvancedCostOptimizationMetrics");
                                if (advancedCostOptimizationMetrics2.getIsEnabled() != null) {
                                    xmlWriter.startElement("IsEnabled").value((Object)advancedCostOptimizationMetrics2.getIsEnabled()).endElement();
                                }
                                xmlWriter.endElement();
                            }
                            if ((advancedDataProtectionMetrics2 = bucketLevel.getAdvancedDataProtectionMetrics()) != null) {
                                xmlWriter.startElement("AdvancedDataProtectionMetrics");
                                if (advancedDataProtectionMetrics2.getIsEnabled() != null) {
                                    xmlWriter.startElement("IsEnabled").value((Object)advancedDataProtectionMetrics2.getIsEnabled()).endElement();
                                }
                                xmlWriter.endElement();
                            }
                            if ((detailedStatusCodesMetrics2 = bucketLevel.getDetailedStatusCodesMetrics()) != null) {
                                xmlWriter.startElement("DetailedStatusCodesMetrics");
                                if (detailedStatusCodesMetrics2.getIsEnabled() != null) {
                                    xmlWriter.startElement("IsEnabled").value((Object)detailedStatusCodesMetrics2.getIsEnabled()).endElement();
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        if ((advancedCostOptimizationMetrics = accountLevel.getAdvancedCostOptimizationMetrics()) != null) {
                            xmlWriter.startElement("AdvancedCostOptimizationMetrics");
                            if (advancedCostOptimizationMetrics.getIsEnabled() != null) {
                                xmlWriter.startElement("IsEnabled").value((Object)advancedCostOptimizationMetrics.getIsEnabled()).endElement();
                            }
                            xmlWriter.endElement();
                        }
                        if ((advancedDataProtectionMetrics = accountLevel.getAdvancedDataProtectionMetrics()) != null) {
                            xmlWriter.startElement("AdvancedDataProtectionMetrics");
                            if (advancedDataProtectionMetrics.getIsEnabled() != null) {
                                xmlWriter.startElement("IsEnabled").value((Object)advancedDataProtectionMetrics.getIsEnabled()).endElement();
                            }
                            xmlWriter.endElement();
                        }
                        if ((detailedStatusCodesMetrics = accountLevel.getDetailedStatusCodesMetrics()) != null) {
                            xmlWriter.startElement("DetailedStatusCodesMetrics");
                            if (detailedStatusCodesMetrics.getIsEnabled() != null) {
                                xmlWriter.startElement("IsEnabled").value((Object)detailedStatusCodesMetrics.getIsEnabled()).endElement();
                            }
                            xmlWriter.endElement();
                        }
                        if ((storageLensGroupLevel = accountLevel.getStorageLensGroupLevel()) != null) {
                            xmlWriter.startElement("StorageLensGroupLevel");
                            StorageLensGroupLevelSelectionCriteria selectionCriteria = storageLensGroupLevel.getSelectionCriteria();
                            if (selectionCriteria != null) {
                                List<String> storageLensGroupLevelSelectionCriteriaExcludeList;
                                xmlWriter.startElement("SelectionCriteria");
                                List<String> list = selectionCriteria.getInclude();
                                if (list != null) {
                                    xmlWriter.startElement("Include");
                                    for (String storageLensGroupLevelSelectionCriteriaIncludeListValue : list) {
                                        xmlWriter.startElement("Arn");
                                        xmlWriter.value(storageLensGroupLevelSelectionCriteriaIncludeListValue);
                                        xmlWriter.endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                if ((storageLensGroupLevelSelectionCriteriaExcludeList = selectionCriteria.getExclude()) != null) {
                                    xmlWriter.startElement("Exclude");
                                    for (String storageLensGroupLevelSelectionCriteriaExcludeListValue : storageLensGroupLevelSelectionCriteriaExcludeList) {
                                        xmlWriter.startElement("Arn");
                                        xmlWriter.value(storageLensGroupLevelSelectionCriteriaExcludeListValue);
                                        xmlWriter.endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    if ((include = storageLensConfiguration.getInclude()) != null) {
                        Object includeRegionsList;
                        xmlWriter.startElement("Include");
                        List<String> includeBucketsList = include.getBuckets();
                        if (includeBucketsList != null) {
                            xmlWriter.startElement("Buckets");
                            for (String string : includeBucketsList) {
                                xmlWriter.startElement("Arn");
                                xmlWriter.value(string);
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        if ((includeRegionsList = include.getRegions()) != null) {
                            xmlWriter.startElement("Regions");
                            Iterator<String> iterator = includeRegionsList.iterator();
                            while (iterator.hasNext()) {
                                String includeRegionsListValue = iterator.next();
                                xmlWriter.startElement("Region");
                                xmlWriter.value(includeRegionsListValue);
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    if ((exclude = storageLensConfiguration.getExclude()) != null) {
                        List<String> excludeRegionsList;
                        xmlWriter.startElement("Exclude");
                        List<String> excludeBucketsList = exclude.getBuckets();
                        if (excludeBucketsList != null) {
                            xmlWriter.startElement("Buckets");
                            for (String string : excludeBucketsList) {
                                xmlWriter.startElement("Arn");
                                xmlWriter.value(string);
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        if ((excludeRegionsList = exclude.getRegions()) != null) {
                            xmlWriter.startElement("Regions");
                            for (String excludeRegionsListValue : excludeRegionsList) {
                                xmlWriter.startElement("Region");
                                xmlWriter.value(excludeRegionsListValue);
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    if ((dataExport = storageLensConfiguration.getDataExport()) != null) {
                        CloudWatchMetrics cloudWatchMetrics;
                        xmlWriter.startElement("DataExport");
                        S3BucketDestination s3BucketDestination = dataExport.getS3BucketDestination();
                        if (s3BucketDestination != null) {
                            StorageLensDataExportEncryption encryption;
                            xmlWriter.startElement("S3BucketDestination");
                            if (s3BucketDestination.getFormat() != null) {
                                xmlWriter.startElement("Format").value(s3BucketDestination.getFormat()).endElement();
                            }
                            if (s3BucketDestination.getOutputSchemaVersion() != null) {
                                xmlWriter.startElement("OutputSchemaVersion").value(s3BucketDestination.getOutputSchemaVersion()).endElement();
                            }
                            if (s3BucketDestination.getAccountId() != null) {
                                xmlWriter.startElement("AccountId").value(s3BucketDestination.getAccountId()).endElement();
                            }
                            if (s3BucketDestination.getArn() != null) {
                                xmlWriter.startElement("Arn").value(s3BucketDestination.getArn()).endElement();
                            }
                            if (s3BucketDestination.getPrefix() != null) {
                                xmlWriter.startElement("Prefix").value(s3BucketDestination.getPrefix()).endElement();
                            }
                            if ((encryption = s3BucketDestination.getEncryption()) != null) {
                                SSEKMS sSEKMS;
                                xmlWriter.startElement("Encryption");
                                SSES3 sSES3 = encryption.getSSES3();
                                if (sSES3 != null) {
                                    xmlWriter.startElement("SSE-S3");
                                    xmlWriter.endElement();
                                }
                                if ((sSEKMS = encryption.getSSEKMS()) != null) {
                                    xmlWriter.startElement("SSE-KMS");
                                    if (sSEKMS.getKeyId() != null) {
                                        xmlWriter.startElement("KeyId").value(sSEKMS.getKeyId()).endElement();
                                    }
                                    xmlWriter.endElement();
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        if ((cloudWatchMetrics = dataExport.getCloudWatchMetrics()) != null) {
                            xmlWriter.startElement("CloudWatchMetrics");
                            if (cloudWatchMetrics.getIsEnabled() != null) {
                                xmlWriter.startElement("IsEnabled").value((Object)cloudWatchMetrics.getIsEnabled()).endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                    if (storageLensConfiguration.getIsEnabled() != null) {
                        xmlWriter.startElement("IsEnabled").value((Object)storageLensConfiguration.getIsEnabled()).endElement();
                    }
                    if ((awsOrg = storageLensConfiguration.getAwsOrg()) != null) {
                        xmlWriter.startElement("AwsOrg");
                        if (awsOrg.getArn() != null) {
                            xmlWriter.startElement("Arn").value(awsOrg.getArn()).endElement();
                        }
                        xmlWriter.endElement();
                    }
                    if (storageLensConfiguration.getStorageLensArn() != null) {
                        xmlWriter.startElement("StorageLensArn").value(storageLensConfiguration.getStorageLensArn()).endElement();
                    }
                    xmlWriter.endElement();
                }
                if ((putStorageLensConfigurationRequestTagsList = putStorageLensConfigurationRequest.getTags()) != null) {
                    xmlWriter.startElement("Tags");
                    for (StorageLensTag putStorageLensConfigurationRequestTagsListValue : putStorageLensConfigurationRequestTagsList) {
                        xmlWriter.startElement("Tag");
                        if (putStorageLensConfigurationRequestTagsListValue.getKey() != null) {
                            xmlWriter.startElement("Key").value(putStorageLensConfigurationRequestTagsListValue.getKey()).endElement();
                        }
                        if (putStorageLensConfigurationRequestTagsListValue.getValue() != null) {
                            xmlWriter.startElement("Value").value(putStorageLensConfigurationRequestTagsListValue.getValue()).endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
            }
            xmlWriter.endElement();
            request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

