/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.s3control.model.CreateBucketConfiguration;
import com.amazonaws.services.s3control.model.CreateBucketRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.XMLWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class CreateBucketRequestMarshaller
implements Marshaller<Request<CreateBucketRequest>, CreateBucketRequest> {
    public Request<CreateBucketRequest> marshall(CreateBucketRequest createBucketRequest) {
        if (createBucketRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createBucketRequest, "AWSS3Control");
        request.setHttpMethod(HttpMethodName.PUT);
        if (createBucketRequest.getACL() != null) {
            request.addHeader("x-amz-acl", StringUtils.fromString((String)createBucketRequest.getACL()));
        }
        if (createBucketRequest.getGrantFullControl() != null) {
            request.addHeader("x-amz-grant-full-control", StringUtils.fromString((String)createBucketRequest.getGrantFullControl()));
        }
        if (createBucketRequest.getGrantRead() != null) {
            request.addHeader("x-amz-grant-read", StringUtils.fromString((String)createBucketRequest.getGrantRead()));
        }
        if (createBucketRequest.getGrantReadACP() != null) {
            request.addHeader("x-amz-grant-read-acp", StringUtils.fromString((String)createBucketRequest.getGrantReadACP()));
        }
        if (createBucketRequest.getGrantWrite() != null) {
            request.addHeader("x-amz-grant-write", StringUtils.fromString((String)createBucketRequest.getGrantWrite()));
        }
        if (createBucketRequest.getGrantWriteACP() != null) {
            request.addHeader("x-amz-grant-write-acp", StringUtils.fromString((String)createBucketRequest.getGrantWriteACP()));
        }
        if (createBucketRequest.getObjectLockEnabledForBucket() != null) {
            request.addHeader("x-amz-bucket-object-lock-enabled", StringUtils.fromBoolean((Boolean)createBucketRequest.getObjectLockEnabledForBucket()));
        }
        if (createBucketRequest.getOutpostId() != null) {
            request.addHeader("x-amz-outpost-id", StringUtils.fromString((String)createBucketRequest.getOutpostId()));
        }
        String uriResourcePath = "/v20180820/bucket/{name}";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "name", createBucketRequest.getBucket());
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter((Writer)stringWriter, "http://awss3control.amazonaws.com/doc/2018-08-20/");
            CreateBucketConfiguration createBucketConfiguration = createBucketRequest.getCreateBucketConfiguration();
            if (createBucketConfiguration != null) {
                xmlWriter.startElement("CreateBucketConfiguration");
                if (createBucketConfiguration.getLocationConstraint() != null) {
                    xmlWriter.startElement("LocationConstraint").value(createBucketConfiguration.getLocationConstraint()).endElement();
                }
                xmlWriter.endElement();
            }
            request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

