/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.s3control.model.MultiRegionAccessPointRoute;
import com.amazonaws.services.s3control.model.SubmitMultiRegionAccessPointRoutesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.XMLWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;

public class SubmitMultiRegionAccessPointRoutesRequestMarshaller
implements Marshaller<Request<SubmitMultiRegionAccessPointRoutesRequest>, SubmitMultiRegionAccessPointRoutesRequest> {
    public Request<SubmitMultiRegionAccessPointRoutesRequest> marshall(SubmitMultiRegionAccessPointRoutesRequest submitMultiRegionAccessPointRoutesRequest) {
        if (submitMultiRegionAccessPointRoutesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)submitMultiRegionAccessPointRoutesRequest, "AWSS3Control");
        request.setHttpMethod(HttpMethodName.PATCH);
        if (submitMultiRegionAccessPointRoutesRequest.getAccountId() != null) {
            request.addHeader("x-amz-account-id", StringUtils.fromString((String)submitMultiRegionAccessPointRoutesRequest.getAccountId()));
        }
        String uriResourcePath = "/v20180820/mrap/instances/{mrap+}/routes";
        uriResourcePath = PathMarshallers.GREEDY.marshall(uriResourcePath, "mrap", submitMultiRegionAccessPointRoutesRequest.getMrap());
        request.setResourcePath(uriResourcePath);
        try {
            List<MultiRegionAccessPointRoute> submitMultiRegionAccessPointRoutesRequestRouteUpdatesList;
            StringWriter stringWriter = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter((Writer)stringWriter, "http://awss3control.amazonaws.com/doc/2018-08-20/");
            xmlWriter.startElement("SubmitMultiRegionAccessPointRoutesRequest");
            if (submitMultiRegionAccessPointRoutesRequest != null && (submitMultiRegionAccessPointRoutesRequestRouteUpdatesList = submitMultiRegionAccessPointRoutesRequest.getRouteUpdates()) != null) {
                xmlWriter.startElement("RouteUpdates");
                for (MultiRegionAccessPointRoute submitMultiRegionAccessPointRoutesRequestRouteUpdatesListValue : submitMultiRegionAccessPointRoutesRequestRouteUpdatesList) {
                    xmlWriter.startElement("Route");
                    if (submitMultiRegionAccessPointRoutesRequestRouteUpdatesListValue.getBucket() != null) {
                        xmlWriter.startElement("Bucket").value(submitMultiRegionAccessPointRoutesRequestRouteUpdatesListValue.getBucket()).endElement();
                    }
                    if (submitMultiRegionAccessPointRoutesRequestRouteUpdatesListValue.getRegion() != null) {
                        xmlWriter.startElement("Region").value(submitMultiRegionAccessPointRoutesRequestRouteUpdatesListValue.getRegion()).endElement();
                    }
                    if (submitMultiRegionAccessPointRoutesRequestRouteUpdatesListValue.getTrafficDialPercentage() != null) {
                        xmlWriter.startElement("TrafficDialPercentage").value((Object)submitMultiRegionAccessPointRoutesRequestRouteUpdatesListValue.getTrafficDialPercentage()).endElement();
                    }
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }
            xmlWriter.endElement();
            request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

