/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.s3control.model.PutBucketPolicyRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.XMLWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class PutBucketPolicyRequestMarshaller
implements Marshaller<Request<PutBucketPolicyRequest>, PutBucketPolicyRequest> {
    public Request<PutBucketPolicyRequest> marshall(PutBucketPolicyRequest putBucketPolicyRequest) {
        if (putBucketPolicyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putBucketPolicyRequest, "AWSS3Control");
        request.setHttpMethod(HttpMethodName.PUT);
        if (putBucketPolicyRequest.getAccountId() != null) {
            request.addHeader("x-amz-account-id", StringUtils.fromString((String)putBucketPolicyRequest.getAccountId()));
        }
        if (putBucketPolicyRequest.getConfirmRemoveSelfBucketAccess() != null) {
            request.addHeader("x-amz-confirm-remove-self-bucket-access", StringUtils.fromBoolean((Boolean)putBucketPolicyRequest.getConfirmRemoveSelfBucketAccess()));
        }
        String uriResourcePath = "/v20180820/bucket/{name}/policy";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "name", putBucketPolicyRequest.getBucket());
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter((Writer)stringWriter, "http://awss3control.amazonaws.com/doc/2018-08-20/");
            xmlWriter.startElement("PutBucketPolicyRequest");
            if (putBucketPolicyRequest != null && putBucketPolicyRequest.getPolicy() != null) {
                xmlWriter.startElement("Policy").value(putBucketPolicyRequest.getPolicy()).endElement();
            }
            xmlWriter.endElement();
            request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

