/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.internal.handlers;

import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.handlers.RequestHandler2;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.s3.request.S3HandlerContextKeys;
import com.amazonaws.util.IOUtils;
import com.amazonaws.util.StringInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@SdkInternalApi
public final class S3ControlHandler
extends RequestHandler2 {
    private static final String PROLOG = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static final String PROLOG_LENGTH = Integer.toString("<?xml version=\"1.0\" encoding=\"UTF-8\"?>".length());
    private static final Log log = LogFactory.getLog(S3ControlHandler.class);

    public void beforeRequest(Request<?> request) {
        request.addHandlerContext(S3HandlerContextKeys.IS_PAYLOAD_SIGNING_ENABLED, (Object)true);
        InputStream content = request.getContent();
        if (content == null && request.getHttpMethod() == HttpMethodName.POST) {
            request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
            return;
        }
        if (this.mightOnlyContainsXmlProlog(request, content)) {
            try {
                String stringContent = IOUtils.toString((InputStream)content);
                if (stringContent.equals(PROLOG)) {
                    request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
                    request.getHeaders().put("Content-Length", "0");
                } else {
                    IOUtils.closeQuietly((Closeable)content, (Log)log);
                    request.setContent((InputStream)new StringInputStream(stringContent));
                }
            }
            catch (IOException e) {
                throw new SdkClientException("Fail to send the request", (Throwable)e);
            }
        }
    }

    private boolean mightOnlyContainsXmlProlog(Request<?> request, InputStream content) {
        return request.getHttpMethod() == HttpMethodName.PUT && PROLOG_LENGTH.equals(request.getHeaders().get("Content-Length")) && content != null;
    }
}

