/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model;

import com.amazonaws.services.s3control.model.S3SSEAlgorithm;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class S3ObjectMetadata
implements Serializable,
Cloneable {
    private String cacheControl;
    private String contentDisposition;
    private String contentEncoding;
    private String contentLanguage;
    private Map<String, String> userMetadata;
    private Long contentLength;
    private String contentMD5;
    private String contentType;
    private Date httpExpiresDate;
    private Boolean requesterCharged;
    private String sSEAlgorithm;

    public void setCacheControl(String cacheControl) {
        this.cacheControl = cacheControl;
    }

    public String getCacheControl() {
        return this.cacheControl;
    }

    public S3ObjectMetadata withCacheControl(String cacheControl) {
        this.setCacheControl(cacheControl);
        return this;
    }

    public void setContentDisposition(String contentDisposition) {
        this.contentDisposition = contentDisposition;
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    public S3ObjectMetadata withContentDisposition(String contentDisposition) {
        this.setContentDisposition(contentDisposition);
        return this;
    }

    public void setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public S3ObjectMetadata withContentEncoding(String contentEncoding) {
        this.setContentEncoding(contentEncoding);
        return this;
    }

    public void setContentLanguage(String contentLanguage) {
        this.contentLanguage = contentLanguage;
    }

    public String getContentLanguage() {
        return this.contentLanguage;
    }

    public S3ObjectMetadata withContentLanguage(String contentLanguage) {
        this.setContentLanguage(contentLanguage);
        return this;
    }

    public Map<String, String> getUserMetadata() {
        return this.userMetadata;
    }

    public void setUserMetadata(Map<String, String> userMetadata) {
        this.userMetadata = userMetadata;
    }

    public S3ObjectMetadata withUserMetadata(Map<String, String> userMetadata) {
        this.setUserMetadata(userMetadata);
        return this;
    }

    public S3ObjectMetadata addUserMetadataEntry(String key, String value) {
        if (null == this.userMetadata) {
            this.userMetadata = new HashMap<String, String>();
        }
        if (this.userMetadata.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.userMetadata.put(key, value);
        return this;
    }

    public S3ObjectMetadata clearUserMetadataEntries() {
        this.userMetadata = null;
        return this;
    }

    public void setContentLength(Long contentLength) {
        this.contentLength = contentLength;
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    public S3ObjectMetadata withContentLength(Long contentLength) {
        this.setContentLength(contentLength);
        return this;
    }

    public void setContentMD5(String contentMD5) {
        this.contentMD5 = contentMD5;
    }

    public String getContentMD5() {
        return this.contentMD5;
    }

    public S3ObjectMetadata withContentMD5(String contentMD5) {
        this.setContentMD5(contentMD5);
        return this;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public S3ObjectMetadata withContentType(String contentType) {
        this.setContentType(contentType);
        return this;
    }

    public void setHttpExpiresDate(Date httpExpiresDate) {
        this.httpExpiresDate = httpExpiresDate;
    }

    public Date getHttpExpiresDate() {
        return this.httpExpiresDate;
    }

    public S3ObjectMetadata withHttpExpiresDate(Date httpExpiresDate) {
        this.setHttpExpiresDate(httpExpiresDate);
        return this;
    }

    public void setRequesterCharged(Boolean requesterCharged) {
        this.requesterCharged = requesterCharged;
    }

    public Boolean getRequesterCharged() {
        return this.requesterCharged;
    }

    public S3ObjectMetadata withRequesterCharged(Boolean requesterCharged) {
        this.setRequesterCharged(requesterCharged);
        return this;
    }

    public Boolean isRequesterCharged() {
        return this.requesterCharged;
    }

    public void setSSEAlgorithm(String sSEAlgorithm) {
        this.sSEAlgorithm = sSEAlgorithm;
    }

    public String getSSEAlgorithm() {
        return this.sSEAlgorithm;
    }

    public S3ObjectMetadata withSSEAlgorithm(String sSEAlgorithm) {
        this.setSSEAlgorithm(sSEAlgorithm);
        return this;
    }

    public S3ObjectMetadata withSSEAlgorithm(S3SSEAlgorithm sSEAlgorithm) {
        this.sSEAlgorithm = sSEAlgorithm.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCacheControl() != null) {
            sb.append("CacheControl: ").append(this.getCacheControl()).append(",");
        }
        if (this.getContentDisposition() != null) {
            sb.append("ContentDisposition: ").append(this.getContentDisposition()).append(",");
        }
        if (this.getContentEncoding() != null) {
            sb.append("ContentEncoding: ").append(this.getContentEncoding()).append(",");
        }
        if (this.getContentLanguage() != null) {
            sb.append("ContentLanguage: ").append(this.getContentLanguage()).append(",");
        }
        if (this.getUserMetadata() != null) {
            sb.append("UserMetadata: ").append(this.getUserMetadata()).append(",");
        }
        if (this.getContentLength() != null) {
            sb.append("ContentLength: ").append(this.getContentLength()).append(",");
        }
        if (this.getContentMD5() != null) {
            sb.append("ContentMD5: ").append(this.getContentMD5()).append(",");
        }
        if (this.getContentType() != null) {
            sb.append("ContentType: ").append(this.getContentType()).append(",");
        }
        if (this.getHttpExpiresDate() != null) {
            sb.append("HttpExpiresDate: ").append(this.getHttpExpiresDate()).append(",");
        }
        if (this.getRequesterCharged() != null) {
            sb.append("RequesterCharged: ").append(this.getRequesterCharged()).append(",");
        }
        if (this.getSSEAlgorithm() != null) {
            sb.append("SSEAlgorithm: ").append(this.getSSEAlgorithm());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3ObjectMetadata)) {
            return false;
        }
        S3ObjectMetadata other = (S3ObjectMetadata)obj;
        if (other.getCacheControl() == null ^ this.getCacheControl() == null) {
            return false;
        }
        if (other.getCacheControl() != null && !other.getCacheControl().equals(this.getCacheControl())) {
            return false;
        }
        if (other.getContentDisposition() == null ^ this.getContentDisposition() == null) {
            return false;
        }
        if (other.getContentDisposition() != null && !other.getContentDisposition().equals(this.getContentDisposition())) {
            return false;
        }
        if (other.getContentEncoding() == null ^ this.getContentEncoding() == null) {
            return false;
        }
        if (other.getContentEncoding() != null && !other.getContentEncoding().equals(this.getContentEncoding())) {
            return false;
        }
        if (other.getContentLanguage() == null ^ this.getContentLanguage() == null) {
            return false;
        }
        if (other.getContentLanguage() != null && !other.getContentLanguage().equals(this.getContentLanguage())) {
            return false;
        }
        if (other.getUserMetadata() == null ^ this.getUserMetadata() == null) {
            return false;
        }
        if (other.getUserMetadata() != null && !other.getUserMetadata().equals(this.getUserMetadata())) {
            return false;
        }
        if (other.getContentLength() == null ^ this.getContentLength() == null) {
            return false;
        }
        if (other.getContentLength() != null && !other.getContentLength().equals(this.getContentLength())) {
            return false;
        }
        if (other.getContentMD5() == null ^ this.getContentMD5() == null) {
            return false;
        }
        if (other.getContentMD5() != null && !other.getContentMD5().equals(this.getContentMD5())) {
            return false;
        }
        if (other.getContentType() == null ^ this.getContentType() == null) {
            return false;
        }
        if (other.getContentType() != null && !other.getContentType().equals(this.getContentType())) {
            return false;
        }
        if (other.getHttpExpiresDate() == null ^ this.getHttpExpiresDate() == null) {
            return false;
        }
        if (other.getHttpExpiresDate() != null && !other.getHttpExpiresDate().equals(this.getHttpExpiresDate())) {
            return false;
        }
        if (other.getRequesterCharged() == null ^ this.getRequesterCharged() == null) {
            return false;
        }
        if (other.getRequesterCharged() != null && !other.getRequesterCharged().equals(this.getRequesterCharged())) {
            return false;
        }
        if (other.getSSEAlgorithm() == null ^ this.getSSEAlgorithm() == null) {
            return false;
        }
        return other.getSSEAlgorithm() == null || other.getSSEAlgorithm().equals(this.getSSEAlgorithm());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCacheControl() == null ? 0 : this.getCacheControl().hashCode());
        hashCode = 31 * hashCode + (this.getContentDisposition() == null ? 0 : this.getContentDisposition().hashCode());
        hashCode = 31 * hashCode + (this.getContentEncoding() == null ? 0 : this.getContentEncoding().hashCode());
        hashCode = 31 * hashCode + (this.getContentLanguage() == null ? 0 : this.getContentLanguage().hashCode());
        hashCode = 31 * hashCode + (this.getUserMetadata() == null ? 0 : this.getUserMetadata().hashCode());
        hashCode = 31 * hashCode + (this.getContentLength() == null ? 0 : this.getContentLength().hashCode());
        hashCode = 31 * hashCode + (this.getContentMD5() == null ? 0 : this.getContentMD5().hashCode());
        hashCode = 31 * hashCode + (this.getContentType() == null ? 0 : this.getContentType().hashCode());
        hashCode = 31 * hashCode + (this.getHttpExpiresDate() == null ? 0 : this.getHttpExpiresDate().hashCode());
        hashCode = 31 * hashCode + (this.getRequesterCharged() == null ? 0 : this.getRequesterCharged().hashCode());
        hashCode = 31 * hashCode + (this.getSSEAlgorithm() == null ? 0 : this.getSSEAlgorithm().hashCode());
        return hashCode;
    }

    public S3ObjectMetadata clone() {
        try {
            return (S3ObjectMetadata)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

