/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.s3control.model.AccessGrantsLocationConfiguration;
import com.amazonaws.services.s3control.model.CreateAccessGrantRequest;
import com.amazonaws.services.s3control.model.Grantee;
import com.amazonaws.services.s3control.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.XMLWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;

public class CreateAccessGrantRequestMarshaller
implements Marshaller<Request<CreateAccessGrantRequest>, CreateAccessGrantRequest> {
    public Request<CreateAccessGrantRequest> marshall(CreateAccessGrantRequest createAccessGrantRequest) {
        if (createAccessGrantRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createAccessGrantRequest, "AWSS3Control");
        request.setHttpMethod(HttpMethodName.POST);
        if (createAccessGrantRequest.getAccountId() != null) {
            request.addHeader("x-amz-account-id", StringUtils.fromString((String)createAccessGrantRequest.getAccountId()));
        }
        String uriResourcePath = "/v20180820/accessgrantsinstance/grant";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter((Writer)stringWriter, "http://awss3control.amazonaws.com/doc/2018-08-20/");
            xmlWriter.startElement("CreateAccessGrantRequest");
            if (createAccessGrantRequest != null) {
                List<Tag> createAccessGrantRequestTagsList;
                Grantee grantee;
                AccessGrantsLocationConfiguration accessGrantsLocationConfiguration;
                if (createAccessGrantRequest.getAccessGrantsLocationId() != null) {
                    xmlWriter.startElement("AccessGrantsLocationId").value(createAccessGrantRequest.getAccessGrantsLocationId()).endElement();
                }
                if ((accessGrantsLocationConfiguration = createAccessGrantRequest.getAccessGrantsLocationConfiguration()) != null) {
                    xmlWriter.startElement("AccessGrantsLocationConfiguration");
                    if (accessGrantsLocationConfiguration.getS3SubPrefix() != null) {
                        xmlWriter.startElement("S3SubPrefix").value(accessGrantsLocationConfiguration.getS3SubPrefix()).endElement();
                    }
                    xmlWriter.endElement();
                }
                if ((grantee = createAccessGrantRequest.getGrantee()) != null) {
                    xmlWriter.startElement("Grantee");
                    if (grantee.getGranteeType() != null) {
                        xmlWriter.startElement("GranteeType").value(grantee.getGranteeType()).endElement();
                    }
                    if (grantee.getGranteeIdentifier() != null) {
                        xmlWriter.startElement("GranteeIdentifier").value(grantee.getGranteeIdentifier()).endElement();
                    }
                    xmlWriter.endElement();
                }
                if (createAccessGrantRequest.getPermission() != null) {
                    xmlWriter.startElement("Permission").value(createAccessGrantRequest.getPermission()).endElement();
                }
                if (createAccessGrantRequest.getApplicationArn() != null) {
                    xmlWriter.startElement("ApplicationArn").value(createAccessGrantRequest.getApplicationArn()).endElement();
                }
                if (createAccessGrantRequest.getS3PrefixType() != null) {
                    xmlWriter.startElement("S3PrefixType").value(createAccessGrantRequest.getS3PrefixType()).endElement();
                }
                if ((createAccessGrantRequestTagsList = createAccessGrantRequest.getTags()) != null) {
                    xmlWriter.startElement("Tags");
                    for (Tag createAccessGrantRequestTagsListValue : createAccessGrantRequestTagsList) {
                        xmlWriter.startElement("Tag");
                        if (createAccessGrantRequestTagsListValue.getKey() != null) {
                            xmlWriter.startElement("Key").value(createAccessGrantRequestTagsListValue.getKey()).endElement();
                        }
                        if (createAccessGrantRequestTagsListValue.getValue() != null) {
                            xmlWriter.startElement("Value").value(createAccessGrantRequestTagsListValue.getValue()).endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
            }
            xmlWriter.endElement();
            request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

