/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.s3control.model.ListAccessGrantsLocationsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ListAccessGrantsLocationsRequestMarshaller
implements Marshaller<Request<ListAccessGrantsLocationsRequest>, ListAccessGrantsLocationsRequest> {
    public Request<ListAccessGrantsLocationsRequest> marshall(ListAccessGrantsLocationsRequest listAccessGrantsLocationsRequest) {
        if (listAccessGrantsLocationsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listAccessGrantsLocationsRequest, "AWSS3Control");
        request.setHttpMethod(HttpMethodName.GET);
        if (listAccessGrantsLocationsRequest.getAccountId() != null) {
            request.addHeader("x-amz-account-id", StringUtils.fromString((String)listAccessGrantsLocationsRequest.getAccountId()));
        }
        String uriResourcePath = "/v20180820/accessgrantsinstance/locations";
        request.setResourcePath(uriResourcePath);
        if (listAccessGrantsLocationsRequest.getNextToken() != null) {
            request.addParameter("nextToken", StringUtils.fromString((String)listAccessGrantsLocationsRequest.getNextToken()));
        }
        if (listAccessGrantsLocationsRequest.getMaxResults() != null) {
            request.addParameter("maxResults", StringUtils.fromInteger((Integer)listAccessGrantsLocationsRequest.getMaxResults()));
        }
        if (listAccessGrantsLocationsRequest.getLocationScope() != null) {
            request.addParameter("locationscope", StringUtils.fromString((String)listAccessGrantsLocationsRequest.getLocationScope()));
        }
        return request;
    }
}

