/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.s3control.model.PutBucketTaggingRequest;
import com.amazonaws.services.s3control.model.S3Tag;
import com.amazonaws.services.s3control.model.Tagging;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.XMLWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;

public class PutBucketTaggingRequestMarshaller
implements Marshaller<Request<PutBucketTaggingRequest>, PutBucketTaggingRequest> {
    public Request<PutBucketTaggingRequest> marshall(PutBucketTaggingRequest putBucketTaggingRequest) {
        if (putBucketTaggingRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putBucketTaggingRequest, "AWSS3Control");
        request.setHttpMethod(HttpMethodName.PUT);
        if (putBucketTaggingRequest.getAccountId() != null) {
            request.addHeader("x-amz-account-id", StringUtils.fromString((String)putBucketTaggingRequest.getAccountId()));
        }
        String uriResourcePath = "/v20180820/bucket/{name}/tagging";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "name", putBucketTaggingRequest.getBucket());
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter((Writer)stringWriter, "http://awss3control.amazonaws.com/doc/2018-08-20/");
            Tagging tagging = putBucketTaggingRequest.getTagging();
            if (tagging != null) {
                xmlWriter.startElement("Tagging");
                List<S3Tag> taggingTagSetList = tagging.getTagSet();
                if (taggingTagSetList != null) {
                    xmlWriter.startElement("TagSet");
                    for (S3Tag taggingTagSetListValue : taggingTagSetList) {
                        xmlWriter.startElement("member");
                        if (taggingTagSetListValue.getKey() != null) {
                            xmlWriter.startElement("Key").value(taggingTagSetListValue.getKey()).endElement();
                        }
                        if (taggingTagSetListValue.getValue() != null) {
                            xmlWriter.startElement("Value").value(taggingTagSetListValue.getValue()).endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }
            request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

