/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.s3control.model.CreateAccessPointRequest;
import com.amazonaws.services.s3control.model.PublicAccessBlockConfiguration;
import com.amazonaws.services.s3control.model.VpcConfiguration;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.XMLWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class CreateAccessPointRequestMarshaller
implements Marshaller<Request<CreateAccessPointRequest>, CreateAccessPointRequest> {
    public Request<CreateAccessPointRequest> marshall(CreateAccessPointRequest createAccessPointRequest) {
        if (createAccessPointRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createAccessPointRequest, "AWSS3Control");
        request.setHttpMethod(HttpMethodName.PUT);
        if (createAccessPointRequest.getAccountId() != null) {
            request.addHeader("x-amz-account-id", StringUtils.fromString((String)createAccessPointRequest.getAccountId()));
        }
        String uriResourcePath = "/v20180820/accesspoint/{name}";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "name", createAccessPointRequest.getName());
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter((Writer)stringWriter, "http://awss3control.amazonaws.com/doc/2018-08-20/");
            xmlWriter.startElement("CreateAccessPointRequest");
            if (createAccessPointRequest != null) {
                PublicAccessBlockConfiguration publicAccessBlockConfiguration;
                VpcConfiguration vpcConfiguration;
                if (createAccessPointRequest.getBucket() != null) {
                    xmlWriter.startElement("Bucket").value(createAccessPointRequest.getBucket()).endElement();
                }
                if ((vpcConfiguration = createAccessPointRequest.getVpcConfiguration()) != null) {
                    xmlWriter.startElement("VpcConfiguration");
                    if (vpcConfiguration.getVpcId() != null) {
                        xmlWriter.startElement("VpcId").value(vpcConfiguration.getVpcId()).endElement();
                    }
                    xmlWriter.endElement();
                }
                if ((publicAccessBlockConfiguration = createAccessPointRequest.getPublicAccessBlockConfiguration()) != null) {
                    xmlWriter.startElement("PublicAccessBlockConfiguration");
                    if (publicAccessBlockConfiguration.getBlockPublicAcls() != null) {
                        xmlWriter.startElement("BlockPublicAcls").value((Object)publicAccessBlockConfiguration.getBlockPublicAcls()).endElement();
                    }
                    if (publicAccessBlockConfiguration.getIgnorePublicAcls() != null) {
                        xmlWriter.startElement("IgnorePublicAcls").value((Object)publicAccessBlockConfiguration.getIgnorePublicAcls()).endElement();
                    }
                    if (publicAccessBlockConfiguration.getBlockPublicPolicy() != null) {
                        xmlWriter.startElement("BlockPublicPolicy").value((Object)publicAccessBlockConfiguration.getBlockPublicPolicy()).endElement();
                    }
                    if (publicAccessBlockConfiguration.getRestrictPublicBuckets() != null) {
                        xmlWriter.startElement("RestrictPublicBuckets").value((Object)publicAccessBlockConfiguration.getRestrictPublicBuckets()).endElement();
                    }
                    xmlWriter.endElement();
                }
                if (createAccessPointRequest.getBucketAccountId() != null) {
                    xmlWriter.startElement("BucketAccountId").value(createAccessPointRequest.getBucketAccountId()).endElement();
                }
            }
            xmlWriter.endElement();
            request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

