/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.s3control.model.GetBucketVersioningRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringUtils;

public class GetBucketVersioningRequestMarshaller
implements Marshaller<Request<GetBucketVersioningRequest>, GetBucketVersioningRequest> {
    public Request<GetBucketVersioningRequest> marshall(GetBucketVersioningRequest getBucketVersioningRequest) {
        if (getBucketVersioningRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getBucketVersioningRequest, "AWSS3Control");
        request.setHttpMethod(HttpMethodName.GET);
        if (getBucketVersioningRequest.getAccountId() != null) {
            request.addHeader("x-amz-account-id", StringUtils.fromString((String)getBucketVersioningRequest.getAccountId()));
        }
        String uriResourcePath = "/v20180820/bucket/{name}/versioning";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "name", getBucketVersioningRequest.getBucket());
        request.setResourcePath(uriResourcePath);
        return request;
    }
}

