/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.services.s3control.model.BucketLevel;
import com.amazonaws.services.s3control.model.transform.ActivityMetricsStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.PrefixLevelStaxUnmarshaller;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class BucketLevelStaxUnmarshaller
implements Unmarshaller<BucketLevel, StaxUnmarshallerContext> {
    private static BucketLevelStaxUnmarshaller instance;

    public BucketLevel unmarshall(StaxUnmarshallerContext context) throws Exception {
        BucketLevel bucketLevel = new BucketLevel();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return bucketLevel;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("ActivityMetrics", targetDepth)) {
                    bucketLevel.setActivityMetrics(ActivityMetricsStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("PrefixLevel", targetDepth)) continue;
                bucketLevel.setPrefixLevel(PrefixLevelStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return bucketLevel;
    }

    public static BucketLevelStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new BucketLevelStaxUnmarshaller();
        }
        return instance;
    }
}

