/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.services.s3control.model.Exclude;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class ExcludeStaxUnmarshaller
implements Unmarshaller<Exclude, StaxUnmarshallerContext> {
    private static ExcludeStaxUnmarshaller instance;

    public Exclude unmarshall(StaxUnmarshallerContext context) throws Exception {
        Exclude exclude = new Exclude();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return exclude;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Buckets", targetDepth)) {
                    exclude.withBuckets(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("Buckets/Arn", targetDepth)) {
                    exclude.withBuckets(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Regions", targetDepth)) {
                    exclude.withRegions(new ArrayList<String>());
                    continue;
                }
                if (!context.testExpression("Regions/Region", targetDepth)) continue;
                exclude.withRegions(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return exclude;
    }

    public static ExcludeStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ExcludeStaxUnmarshaller();
        }
        return instance;
    }
}

