/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.services.s3control.model.LifecycleRule;
import com.amazonaws.services.s3control.model.NoncurrentVersionTransition;
import com.amazonaws.services.s3control.model.Transition;
import com.amazonaws.services.s3control.model.transform.AbortIncompleteMultipartUploadStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.LifecycleExpirationStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.LifecycleRuleFilterStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.NoncurrentVersionExpirationStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.NoncurrentVersionTransitionStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.TransitionStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class LifecycleRuleStaxUnmarshaller
implements Unmarshaller<LifecycleRule, StaxUnmarshallerContext> {
    private static LifecycleRuleStaxUnmarshaller instance;

    public LifecycleRule unmarshall(StaxUnmarshallerContext context) throws Exception {
        LifecycleRule lifecycleRule = new LifecycleRule();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return lifecycleRule;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Expiration", targetDepth)) {
                    lifecycleRule.setExpiration(LifecycleExpirationStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ID", targetDepth)) {
                    lifecycleRule.setID(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Filter", targetDepth)) {
                    lifecycleRule.setFilter(LifecycleRuleFilterStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Status", targetDepth)) {
                    lifecycleRule.setStatus(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Transitions", targetDepth)) {
                    lifecycleRule.withTransitions(new ArrayList<Transition>());
                    continue;
                }
                if (context.testExpression("Transitions/Transition", targetDepth)) {
                    lifecycleRule.withTransitions(TransitionStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("NoncurrentVersionTransitions", targetDepth)) {
                    lifecycleRule.withNoncurrentVersionTransitions(new ArrayList<NoncurrentVersionTransition>());
                    continue;
                }
                if (context.testExpression("NoncurrentVersionTransitions/NoncurrentVersionTransition", targetDepth)) {
                    lifecycleRule.withNoncurrentVersionTransitions(NoncurrentVersionTransitionStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("NoncurrentVersionExpiration", targetDepth)) {
                    lifecycleRule.setNoncurrentVersionExpiration(NoncurrentVersionExpirationStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("AbortIncompleteMultipartUpload", targetDepth)) continue;
                lifecycleRule.setAbortIncompleteMultipartUpload(AbortIncompleteMultipartUploadStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return lifecycleRule;
    }

    public static LifecycleRuleStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new LifecycleRuleStaxUnmarshaller();
        }
        return instance;
    }
}

