/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.internal;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.s3.S3Resource;
import com.amazonaws.services.s3.S3ResourceType;
import com.amazonaws.services.s3control.internal.S3ControlResourceType;
import com.amazonaws.util.ValidationUtils;

@SdkInternalApi
public final class S3ControlBucketResource
implements S3Resource {
    private final String partition;
    private final String region;
    private final String accountId;
    private final String bucketName;
    private final S3Resource parentS3Resource;

    private S3ControlBucketResource(Builder b) {
        this.bucketName = ValidationUtils.assertStringNotEmpty((String)b.bucketName, (String)"bucketName");
        if (b.parentS3Resource == null) {
            this.parentS3Resource = null;
            this.partition = b.partition;
            this.region = b.region;
            this.accountId = b.accountId;
        } else {
            this.parentS3Resource = this.validateParentS3Resource(b.parentS3Resource);
            ValidationUtils.assertAllAreNull((String)"partition cannot be set on builder if it has parent resource", (Object[])new Object[]{b.partition});
            ValidationUtils.assertAllAreNull((String)"region cannot be set on builder if it has parent resource", (Object[])new Object[]{b.region});
            ValidationUtils.assertAllAreNull((String)"accountId cannot be set on builder if it has parent resource", (Object[])new Object[]{b.accountId});
            this.partition = this.parentS3Resource.getPartition();
            this.region = this.parentS3Resource.getRegion();
            this.accountId = this.parentS3Resource.getAccountId();
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getType() {
        return S3ControlResourceType.BUCKET.toString();
    }

    public String getPartition() {
        return this.partition;
    }

    public String getRegion() {
        return this.region;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public S3Resource getParentS3Resource() {
        return this.parentS3Resource;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        S3ControlBucketResource that = (S3ControlBucketResource)o;
        if (this.partition != null ? !this.partition.equals(that.partition) : that.partition != null) {
            return false;
        }
        if (this.region != null ? !this.region.equals(that.region) : that.region != null) {
            return false;
        }
        if (this.accountId != null ? !this.accountId.equals(that.accountId) : that.accountId != null) {
            return false;
        }
        if (this.parentS3Resource != null ? !this.parentS3Resource.equals(that.parentS3Resource) : that.parentS3Resource != null) {
            return false;
        }
        return this.bucketName.equals(that.bucketName);
    }

    public int hashCode() {
        int result = this.partition != null ? this.partition.hashCode() : 0;
        result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
        result = 31 * result + (this.accountId != null ? this.accountId.hashCode() : 0);
        result = 31 * result + this.bucketName.hashCode();
        result = 31 * result + (this.parentS3Resource != null ? this.parentS3Resource.hashCode() : 0);
        return result;
    }

    private S3Resource validateParentS3Resource(S3Resource parentS3Resource) {
        if (!S3ResourceType.OUTPOST.toString().equals(parentS3Resource.getType())) {
            throw new IllegalArgumentException("Invalid 'parentS3Resource' type. An S3 bucket resource must be associated with an outpost parent resource.");
        }
        return parentS3Resource;
    }

    public static final class Builder {
        private String partition;
        private String region;
        private String accountId;
        private String bucketName;
        private S3Resource parentS3Resource;

        public void setPartition(String partition) {
            this.partition = partition;
        }

        public Builder withPartition(String partition) {
            this.setPartition(partition);
            return this;
        }

        public void setRegion(String region) {
            this.region = region;
        }

        public Builder withRegion(String region) {
            this.setRegion(region);
            return this;
        }

        public void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public Builder withAccountId(String accountId) {
            this.setAccountId(accountId);
            return this;
        }

        public void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        public Builder withBucketName(String bucketName) {
            this.setBucketName(bucketName);
            return this;
        }

        public Builder withParentS3Resource(S3Resource parentS3Resource) {
            this.parentS3Resource = parentS3Resource;
            return this;
        }

        public S3ControlBucketResource build() {
            return new S3ControlBucketResource(this);
        }
    }
}

