/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control.model.transform;

import com.amazonaws.services.s3control.model.AccountLevel;
import com.amazonaws.services.s3control.model.transform.ActivityMetricsStaxUnmarshaller;
import com.amazonaws.services.s3control.model.transform.BucketLevelStaxUnmarshaller;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class AccountLevelStaxUnmarshaller
implements Unmarshaller<AccountLevel, StaxUnmarshallerContext> {
    private static AccountLevelStaxUnmarshaller instance;

    public AccountLevel unmarshall(StaxUnmarshallerContext context) throws Exception {
        AccountLevel accountLevel = new AccountLevel();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return accountLevel;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("ActivityMetrics", targetDepth)) {
                    accountLevel.setActivityMetrics(ActivityMetricsStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("BucketLevel", targetDepth)) continue;
                accountLevel.setBucketLevel(BucketLevelStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return accountLevel;
    }

    public static AccountLevelStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new AccountLevelStaxUnmarshaller();
        }
        return instance;
    }
}

