/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3control;

import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.annotation.NotThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.builder.AwsAsyncClientBuilder;
import com.amazonaws.services.s3control.AWSS3ControlAsync;
import com.amazonaws.services.s3control.AWSS3ControlAsyncClient;
import com.amazonaws.services.s3control.S3ControlClientOptions;

@NotThreadSafe
public final class AWSS3ControlAsyncClientBuilder
extends AwsAsyncClientBuilder<AWSS3ControlAsyncClientBuilder, AWSS3ControlAsync> {
    private static final ClientConfigurationFactory CLIENT_CONFIG_FACTORY = new ClientConfigurationFactory();

    public static AWSS3ControlAsyncClientBuilder standard() {
        return new AWSS3ControlAsyncClientBuilder();
    }

    public static AWSS3ControlAsync defaultClient() {
        return (AWSS3ControlAsync)AWSS3ControlAsyncClientBuilder.standard().build();
    }

    private AWSS3ControlAsyncClientBuilder() {
        super(CLIENT_CONFIG_FACTORY);
    }

    public Boolean isDualstackEnabled() {
        return (Boolean)super.getAdvancedConfig(S3ControlClientOptions.DUALSTACK_ENABLED);
    }

    public AWSS3ControlAsyncClientBuilder enableDualstack() {
        return this.withDualstackEnabled(true);
    }

    public void setDualstackEnabled(Boolean dualstackEnabled) {
        super.putAdvancedConfig(S3ControlClientOptions.DUALSTACK_ENABLED, (Object)dualstackEnabled);
    }

    public AWSS3ControlAsyncClientBuilder withDualstackEnabled(Boolean dualstackEnabled) {
        this.setDualstackEnabled(dualstackEnabled);
        return this;
    }

    public Boolean isFipsEnabled() {
        return (Boolean)super.getAdvancedConfig(S3ControlClientOptions.FIPS_ENABLED);
    }

    public AWSS3ControlAsyncClientBuilder enableFips() {
        return this.withFipsEnabled(true);
    }

    public void setFipsEnabled(Boolean fipsEnabled) {
        super.putAdvancedConfig(S3ControlClientOptions.FIPS_ENABLED, (Object)fipsEnabled);
    }

    public AWSS3ControlAsyncClientBuilder withFipsEnabled(Boolean fipsEnabled) {
        this.setFipsEnabled(fipsEnabled);
        return this;
    }

    public AWSS3ControlAsyncClientBuilder enableUseArnRegion() {
        this.setUseArnRegionEnabled(true);
        return this;
    }

    public void setUseArnRegionEnabled(Boolean useArnRegionEnabled) {
        super.putAdvancedConfig(S3ControlClientOptions.USE_ARN_REGION_ENABLED, (Object)useArnRegionEnabled);
    }

    public AWSS3ControlAsyncClientBuilder withUseArnRegionEnabled(Boolean useArnRegionEnabled) {
        this.setUseArnRegionEnabled(true);
        return this;
    }

    protected AWSS3ControlAsync build(AwsAsyncClientParams params) {
        return new AWSS3ControlAsyncClient(params);
    }
}

