/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53resolver.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.route53resolver.model.FirewallDomainUpdateOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateFirewallDomainsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String firewallDomainListId;
    private String operation;
    private List<String> domains;

    public void setFirewallDomainListId(String firewallDomainListId) {
        this.firewallDomainListId = firewallDomainListId;
    }

    public String getFirewallDomainListId() {
        return this.firewallDomainListId;
    }

    public UpdateFirewallDomainsRequest withFirewallDomainListId(String firewallDomainListId) {
        this.setFirewallDomainListId(firewallDomainListId);
        return this;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public String getOperation() {
        return this.operation;
    }

    public UpdateFirewallDomainsRequest withOperation(String operation) {
        this.setOperation(operation);
        return this;
    }

    public UpdateFirewallDomainsRequest withOperation(FirewallDomainUpdateOperation operation) {
        this.operation = operation.toString();
        return this;
    }

    public List<String> getDomains() {
        return this.domains;
    }

    public void setDomains(Collection<String> domains) {
        if (domains == null) {
            this.domains = null;
            return;
        }
        this.domains = new ArrayList<String>(domains);
    }

    public UpdateFirewallDomainsRequest withDomains(String ... domains) {
        if (this.domains == null) {
            this.setDomains(new ArrayList<String>(domains.length));
        }
        for (String ele : domains) {
            this.domains.add(ele);
        }
        return this;
    }

    public UpdateFirewallDomainsRequest withDomains(Collection<String> domains) {
        this.setDomains(domains);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFirewallDomainListId() != null) {
            sb.append("FirewallDomainListId: ").append(this.getFirewallDomainListId()).append(",");
        }
        if (this.getOperation() != null) {
            sb.append("Operation: ").append(this.getOperation()).append(",");
        }
        if (this.getDomains() != null) {
            sb.append("Domains: ").append(this.getDomains());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFirewallDomainsRequest)) {
            return false;
        }
        UpdateFirewallDomainsRequest other = (UpdateFirewallDomainsRequest)obj;
        if (other.getFirewallDomainListId() == null ^ this.getFirewallDomainListId() == null) {
            return false;
        }
        if (other.getFirewallDomainListId() != null && !other.getFirewallDomainListId().equals(this.getFirewallDomainListId())) {
            return false;
        }
        if (other.getOperation() == null ^ this.getOperation() == null) {
            return false;
        }
        if (other.getOperation() != null && !other.getOperation().equals(this.getOperation())) {
            return false;
        }
        if (other.getDomains() == null ^ this.getDomains() == null) {
            return false;
        }
        return other.getDomains() == null || other.getDomains().equals(this.getDomains());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFirewallDomainListId() == null ? 0 : this.getFirewallDomainListId().hashCode());
        hashCode = 31 * hashCode + (this.getOperation() == null ? 0 : this.getOperation().hashCode());
        hashCode = 31 * hashCode + (this.getDomains() == null ? 0 : this.getDomains().hashCode());
        return hashCode;
    }

    public UpdateFirewallDomainsRequest clone() {
        return (UpdateFirewallDomainsRequest)super.clone();
    }
}

