/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53profiles;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.route53profiles.AWSRoute53ProfilesAsync;
import com.amazonaws.services.route53profiles.AWSRoute53ProfilesAsyncClientBuilder;
import com.amazonaws.services.route53profiles.AWSRoute53ProfilesClient;
import com.amazonaws.services.route53profiles.model.AssociateProfileRequest;
import com.amazonaws.services.route53profiles.model.AssociateProfileResult;
import com.amazonaws.services.route53profiles.model.AssociateResourceToProfileRequest;
import com.amazonaws.services.route53profiles.model.AssociateResourceToProfileResult;
import com.amazonaws.services.route53profiles.model.CreateProfileRequest;
import com.amazonaws.services.route53profiles.model.CreateProfileResult;
import com.amazonaws.services.route53profiles.model.DeleteProfileRequest;
import com.amazonaws.services.route53profiles.model.DeleteProfileResult;
import com.amazonaws.services.route53profiles.model.DisassociateProfileRequest;
import com.amazonaws.services.route53profiles.model.DisassociateProfileResult;
import com.amazonaws.services.route53profiles.model.DisassociateResourceFromProfileRequest;
import com.amazonaws.services.route53profiles.model.DisassociateResourceFromProfileResult;
import com.amazonaws.services.route53profiles.model.GetProfileAssociationRequest;
import com.amazonaws.services.route53profiles.model.GetProfileAssociationResult;
import com.amazonaws.services.route53profiles.model.GetProfileRequest;
import com.amazonaws.services.route53profiles.model.GetProfileResourceAssociationRequest;
import com.amazonaws.services.route53profiles.model.GetProfileResourceAssociationResult;
import com.amazonaws.services.route53profiles.model.GetProfileResult;
import com.amazonaws.services.route53profiles.model.ListProfileAssociationsRequest;
import com.amazonaws.services.route53profiles.model.ListProfileAssociationsResult;
import com.amazonaws.services.route53profiles.model.ListProfileResourceAssociationsRequest;
import com.amazonaws.services.route53profiles.model.ListProfileResourceAssociationsResult;
import com.amazonaws.services.route53profiles.model.ListProfilesRequest;
import com.amazonaws.services.route53profiles.model.ListProfilesResult;
import com.amazonaws.services.route53profiles.model.ListTagsForResourceRequest;
import com.amazonaws.services.route53profiles.model.ListTagsForResourceResult;
import com.amazonaws.services.route53profiles.model.TagResourceRequest;
import com.amazonaws.services.route53profiles.model.TagResourceResult;
import com.amazonaws.services.route53profiles.model.UntagResourceRequest;
import com.amazonaws.services.route53profiles.model.UntagResourceResult;
import com.amazonaws.services.route53profiles.model.UpdateProfileResourceAssociationRequest;
import com.amazonaws.services.route53profiles.model.UpdateProfileResourceAssociationResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSRoute53ProfilesAsyncClient
extends AWSRoute53ProfilesClient
implements AWSRoute53ProfilesAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSRoute53ProfilesAsyncClientBuilder asyncBuilder() {
        return AWSRoute53ProfilesAsyncClientBuilder.standard();
    }

    AWSRoute53ProfilesAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSRoute53ProfilesAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AssociateProfileResult> associateProfileAsync(AssociateProfileRequest request) {
        return this.associateProfileAsync(request, null);
    }

    @Override
    public Future<AssociateProfileResult> associateProfileAsync(AssociateProfileRequest request, final AsyncHandler<AssociateProfileRequest, AssociateProfileResult> asyncHandler) {
        final AssociateProfileRequest finalRequest = (AssociateProfileRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AssociateProfileResult>(){

            @Override
            public AssociateProfileResult call() throws Exception {
                AssociateProfileResult result = null;
                try {
                    result = AWSRoute53ProfilesAsyncClient.this.executeAssociateProfile(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AssociateResourceToProfileResult> associateResourceToProfileAsync(AssociateResourceToProfileRequest request) {
        return this.associateResourceToProfileAsync(request, null);
    }

    @Override
    public Future<AssociateResourceToProfileResult> associateResourceToProfileAsync(AssociateResourceToProfileRequest request, final AsyncHandler<AssociateResourceToProfileRequest, AssociateResourceToProfileResult> asyncHandler) {
        final AssociateResourceToProfileRequest finalRequest = (AssociateResourceToProfileRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AssociateResourceToProfileResult>(){

            @Override
            public AssociateResourceToProfileResult call() throws Exception {
                AssociateResourceToProfileResult result = null;
                try {
                    result = AWSRoute53ProfilesAsyncClient.this.executeAssociateResourceToProfile(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateProfileResult> createProfileAsync(CreateProfileRequest request) {
        return this.createProfileAsync(request, null);
    }

    @Override
    public Future<CreateProfileResult> createProfileAsync(CreateProfileRequest request, final AsyncHandler<CreateProfileRequest, CreateProfileResult> asyncHandler) {
        final CreateProfileRequest finalRequest = (CreateProfileRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateProfileResult>(){

            @Override
            public CreateProfileResult call() throws Exception {
                CreateProfileResult result = null;
                try {
                    result = AWSRoute53ProfilesAsyncClient.this.executeCreateProfile(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteProfileResult> deleteProfileAsync(DeleteProfileRequest request) {
        return this.deleteProfileAsync(request, null);
    }

    @Override
    public Future<DeleteProfileResult> deleteProfileAsync(DeleteProfileRequest request, final AsyncHandler<DeleteProfileRequest, DeleteProfileResult> asyncHandler) {
        final DeleteProfileRequest finalRequest = (DeleteProfileRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteProfileResult>(){

            @Override
            public DeleteProfileResult call() throws Exception {
                DeleteProfileResult result = null;
                try {
                    result = AWSRoute53ProfilesAsyncClient.this.executeDeleteProfile(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisassociateProfileResult> disassociateProfileAsync(DisassociateProfileRequest request) {
        return this.disassociateProfileAsync(request, null);
    }

    @Override
    public Future<DisassociateProfileResult> disassociateProfileAsync(DisassociateProfileRequest request, final AsyncHandler<DisassociateProfileRequest, DisassociateProfileResult> asyncHandler) {
        final DisassociateProfileRequest finalRequest = (DisassociateProfileRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DisassociateProfileResult>(){

            @Override
            public DisassociateProfileResult call() throws Exception {
                DisassociateProfileResult result = null;
                try {
                    result = AWSRoute53ProfilesAsyncClient.this.executeDisassociateProfile(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisassociateResourceFromProfileResult> disassociateResourceFromProfileAsync(DisassociateResourceFromProfileRequest request) {
        return this.disassociateResourceFromProfileAsync(request, null);
    }

    @Override
    public Future<DisassociateResourceFromProfileResult> disassociateResourceFromProfileAsync(DisassociateResourceFromProfileRequest request, final AsyncHandler<DisassociateResourceFromProfileRequest, DisassociateResourceFromProfileResult> asyncHandler) {
        final DisassociateResourceFromProfileRequest finalRequest = (DisassociateResourceFromProfileRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DisassociateResourceFromProfileResult>(){

            @Override
            public DisassociateResourceFromProfileResult call() throws Exception {
                DisassociateResourceFromProfileResult result = null;
                try {
                    result = AWSRoute53ProfilesAsyncClient.this.executeDisassociateResourceFromProfile(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetProfileResult> getProfileAsync(GetProfileRequest request) {
        return this.getProfileAsync(request, null);
    }

    @Override
    public Future<GetProfileResult> getProfileAsync(GetProfileRequest request, final AsyncHandler<GetProfileRequest, GetProfileResult> asyncHandler) {
        final GetProfileRequest finalRequest = (GetProfileRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetProfileResult>(){

            @Override
            public GetProfileResult call() throws Exception {
                GetProfileResult result = null;
                try {
                    result = AWSRoute53ProfilesAsyncClient.this.executeGetProfile(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetProfileAssociationResult> getProfileAssociationAsync(GetProfileAssociationRequest request) {
        return this.getProfileAssociationAsync(request, null);
    }

    @Override
    public Future<GetProfileAssociationResult> getProfileAssociationAsync(GetProfileAssociationRequest request, final AsyncHandler<GetProfileAssociationRequest, GetProfileAssociationResult> asyncHandler) {
        final GetProfileAssociationRequest finalRequest = (GetProfileAssociationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetProfileAssociationResult>(){

            @Override
            public GetProfileAssociationResult call() throws Exception {
                GetProfileAssociationResult result = null;
                try {
                    result = AWSRoute53ProfilesAsyncClient.this.executeGetProfileAssociation(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetProfileResourceAssociationResult> getProfileResourceAssociationAsync(GetProfileResourceAssociationRequest request) {
        return this.getProfileResourceAssociationAsync(request, null);
    }

    @Override
    public Future<GetProfileResourceAssociationResult> getProfileResourceAssociationAsync(GetProfileResourceAssociationRequest request, final AsyncHandler<GetProfileResourceAssociationRequest, GetProfileResourceAssociationResult> asyncHandler) {
        final GetProfileResourceAssociationRequest finalRequest = (GetProfileResourceAssociationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetProfileResourceAssociationResult>(){

            @Override
            public GetProfileResourceAssociationResult call() throws Exception {
                GetProfileResourceAssociationResult result = null;
                try {
                    result = AWSRoute53ProfilesAsyncClient.this.executeGetProfileResourceAssociation(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListProfileAssociationsResult> listProfileAssociationsAsync(ListProfileAssociationsRequest request) {
        return this.listProfileAssociationsAsync(request, null);
    }

    @Override
    public Future<ListProfileAssociationsResult> listProfileAssociationsAsync(ListProfileAssociationsRequest request, final AsyncHandler<ListProfileAssociationsRequest, ListProfileAssociationsResult> asyncHandler) {
        final ListProfileAssociationsRequest finalRequest = (ListProfileAssociationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListProfileAssociationsResult>(){

            @Override
            public ListProfileAssociationsResult call() throws Exception {
                ListProfileAssociationsResult result = null;
                try {
                    result = AWSRoute53ProfilesAsyncClient.this.executeListProfileAssociations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListProfileResourceAssociationsResult> listProfileResourceAssociationsAsync(ListProfileResourceAssociationsRequest request) {
        return this.listProfileResourceAssociationsAsync(request, null);
    }

    @Override
    public Future<ListProfileResourceAssociationsResult> listProfileResourceAssociationsAsync(ListProfileResourceAssociationsRequest request, final AsyncHandler<ListProfileResourceAssociationsRequest, ListProfileResourceAssociationsResult> asyncHandler) {
        final ListProfileResourceAssociationsRequest finalRequest = (ListProfileResourceAssociationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListProfileResourceAssociationsResult>(){

            @Override
            public ListProfileResourceAssociationsResult call() throws Exception {
                ListProfileResourceAssociationsResult result = null;
                try {
                    result = AWSRoute53ProfilesAsyncClient.this.executeListProfileResourceAssociations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListProfilesResult> listProfilesAsync(ListProfilesRequest request) {
        return this.listProfilesAsync(request, null);
    }

    @Override
    public Future<ListProfilesResult> listProfilesAsync(ListProfilesRequest request, final AsyncHandler<ListProfilesRequest, ListProfilesResult> asyncHandler) {
        final ListProfilesRequest finalRequest = (ListProfilesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListProfilesResult>(){

            @Override
            public ListProfilesResult call() throws Exception {
                ListProfilesResult result = null;
                try {
                    result = AWSRoute53ProfilesAsyncClient.this.executeListProfiles(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSRoute53ProfilesAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSRoute53ProfilesAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSRoute53ProfilesAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateProfileResourceAssociationResult> updateProfileResourceAssociationAsync(UpdateProfileResourceAssociationRequest request) {
        return this.updateProfileResourceAssociationAsync(request, null);
    }

    @Override
    public Future<UpdateProfileResourceAssociationResult> updateProfileResourceAssociationAsync(UpdateProfileResourceAssociationRequest request, final AsyncHandler<UpdateProfileResourceAssociationRequest, UpdateProfileResourceAssociationResult> asyncHandler) {
        final UpdateProfileResourceAssociationRequest finalRequest = (UpdateProfileResourceAssociationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateProfileResourceAssociationResult>(){

            @Override
            public UpdateProfileResourceAssociationResult call() throws Exception {
                UpdateProfileResourceAssociationResult result = null;
                try {
                    result = AWSRoute53ProfilesAsyncClient.this.executeUpdateProfileResourceAssociation(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

