/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53domains.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.route53domains.model.DnssecKey;

@SdkInternalApi
public class DnssecKeyMarshaller {
    private static final MarshallingInfo<Integer> ALGORITHM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Algorithm").build();
    private static final MarshallingInfo<Integer> FLAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Flags").build();
    private static final MarshallingInfo<String> PUBLICKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PublicKey").build();
    private static final MarshallingInfo<Integer> DIGESTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DigestType").build();
    private static final MarshallingInfo<String> DIGEST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Digest").build();
    private static final MarshallingInfo<Integer> KEYTAG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeyTag").build();
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").build();
    private static final DnssecKeyMarshaller instance = new DnssecKeyMarshaller();

    public static DnssecKeyMarshaller getInstance() {
        return instance;
    }

    public void marshall(DnssecKey dnssecKey, ProtocolMarshaller protocolMarshaller) {
        if (dnssecKey == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)dnssecKey.getAlgorithm(), ALGORITHM_BINDING);
            protocolMarshaller.marshall((Object)dnssecKey.getFlags(), FLAGS_BINDING);
            protocolMarshaller.marshall((Object)dnssecKey.getPublicKey(), PUBLICKEY_BINDING);
            protocolMarshaller.marshall((Object)dnssecKey.getDigestType(), DIGESTTYPE_BINDING);
            protocolMarshaller.marshall((Object)dnssecKey.getDigest(), DIGEST_BINDING);
            protocolMarshaller.marshall((Object)dnssecKey.getKeyTag(), KEYTAG_BINDING);
            protocolMarshaller.marshall((Object)dnssecKey.getId(), ID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

