/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53domains.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.route53domains.model.RenewDomainRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class RenewDomainRequestMarshaller
implements Marshaller<Request<RenewDomainRequest>, RenewDomainRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public RenewDomainRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<RenewDomainRequest> marshall(RenewDomainRequest renewDomainRequest) {
        if (renewDomainRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)renewDomainRequest, "AmazonRoute53Domains");
        request.addHeader("X-Amz-Target", "Route53Domains_v20140515.RenewDomain");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (renewDomainRequest.getDomainName() != null) {
                jsonGenerator.writeFieldName("DomainName").writeValue(renewDomainRequest.getDomainName());
            }
            if (renewDomainRequest.getDurationInYears() != null) {
                jsonGenerator.writeFieldName("DurationInYears").writeValue(renewDomainRequest.getDurationInYears().intValue());
            }
            if (renewDomainRequest.getCurrentExpiryYear() != null) {
                jsonGenerator.writeFieldName("CurrentExpiryYear").writeValue(renewDomainRequest.getCurrentExpiryYear().intValue());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

