/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53domains.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.route53domains.model.ContactDetail;
import com.amazonaws.services.route53domains.model.ExtraParam;
import com.amazonaws.services.route53domains.model.transform.ExtraParamJsonMarshaller;

public class ContactDetailJsonMarshaller {
    private static ContactDetailJsonMarshaller instance;

    public void marshall(ContactDetail contactDetail, StructuredJsonGenerator jsonGenerator) {
        if (contactDetail == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList extraParamsList;
            jsonGenerator.writeStartObject();
            if (contactDetail.getFirstName() != null) {
                jsonGenerator.writeFieldName("FirstName").writeValue(contactDetail.getFirstName());
            }
            if (contactDetail.getLastName() != null) {
                jsonGenerator.writeFieldName("LastName").writeValue(contactDetail.getLastName());
            }
            if (contactDetail.getContactType() != null) {
                jsonGenerator.writeFieldName("ContactType").writeValue(contactDetail.getContactType());
            }
            if (contactDetail.getOrganizationName() != null) {
                jsonGenerator.writeFieldName("OrganizationName").writeValue(contactDetail.getOrganizationName());
            }
            if (contactDetail.getAddressLine1() != null) {
                jsonGenerator.writeFieldName("AddressLine1").writeValue(contactDetail.getAddressLine1());
            }
            if (contactDetail.getAddressLine2() != null) {
                jsonGenerator.writeFieldName("AddressLine2").writeValue(contactDetail.getAddressLine2());
            }
            if (contactDetail.getCity() != null) {
                jsonGenerator.writeFieldName("City").writeValue(contactDetail.getCity());
            }
            if (contactDetail.getState() != null) {
                jsonGenerator.writeFieldName("State").writeValue(contactDetail.getState());
            }
            if (contactDetail.getCountryCode() != null) {
                jsonGenerator.writeFieldName("CountryCode").writeValue(contactDetail.getCountryCode());
            }
            if (contactDetail.getZipCode() != null) {
                jsonGenerator.writeFieldName("ZipCode").writeValue(contactDetail.getZipCode());
            }
            if (contactDetail.getPhoneNumber() != null) {
                jsonGenerator.writeFieldName("PhoneNumber").writeValue(contactDetail.getPhoneNumber());
            }
            if (contactDetail.getEmail() != null) {
                jsonGenerator.writeFieldName("Email").writeValue(contactDetail.getEmail());
            }
            if (contactDetail.getFax() != null) {
                jsonGenerator.writeFieldName("Fax").writeValue(contactDetail.getFax());
            }
            if (!(extraParamsList = (SdkInternalList)contactDetail.getExtraParams()).isEmpty() || !extraParamsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("ExtraParams");
                jsonGenerator.writeStartArray();
                for (ExtraParam extraParamsListValue : extraParamsList) {
                    if (extraParamsListValue == null) continue;
                    ExtraParamJsonMarshaller.getInstance().marshall(extraParamsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ContactDetailJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ContactDetailJsonMarshaller();
        }
        return instance;
    }
}

