/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53domains.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.route53domains.model.OperationSummary;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ListOperationsResult
implements Serializable,
Cloneable {
    private SdkInternalList<OperationSummary> operations;
    private String nextPageMarker;

    public List<OperationSummary> getOperations() {
        if (this.operations == null) {
            this.operations = new SdkInternalList();
        }
        return this.operations;
    }

    public void setOperations(Collection<OperationSummary> operations) {
        if (operations == null) {
            this.operations = null;
            return;
        }
        this.operations = new SdkInternalList(operations);
    }

    public ListOperationsResult withOperations(OperationSummary ... operations) {
        if (this.operations == null) {
            this.setOperations((Collection<OperationSummary>)new SdkInternalList(operations.length));
        }
        for (OperationSummary ele : operations) {
            this.operations.add((Object)ele);
        }
        return this;
    }

    public ListOperationsResult withOperations(Collection<OperationSummary> operations) {
        this.setOperations(operations);
        return this;
    }

    public void setNextPageMarker(String nextPageMarker) {
        this.nextPageMarker = nextPageMarker;
    }

    public String getNextPageMarker() {
        return this.nextPageMarker;
    }

    public ListOperationsResult withNextPageMarker(String nextPageMarker) {
        this.setNextPageMarker(nextPageMarker);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getOperations() != null) {
            sb.append("Operations: " + this.getOperations() + ",");
        }
        if (this.getNextPageMarker() != null) {
            sb.append("NextPageMarker: " + this.getNextPageMarker());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOperationsResult)) {
            return false;
        }
        ListOperationsResult other = (ListOperationsResult)obj;
        if (other.getOperations() == null ^ this.getOperations() == null) {
            return false;
        }
        if (other.getOperations() != null && !other.getOperations().equals(this.getOperations())) {
            return false;
        }
        if (other.getNextPageMarker() == null ^ this.getNextPageMarker() == null) {
            return false;
        }
        return other.getNextPageMarker() == null || other.getNextPageMarker().equals(this.getNextPageMarker());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getOperations() == null ? 0 : this.getOperations().hashCode());
        hashCode = 31 * hashCode + (this.getNextPageMarker() == null ? 0 : this.getNextPageMarker().hashCode());
        return hashCode;
    }

    public ListOperationsResult clone() {
        try {
            return (ListOperationsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

