/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.route53.model.ListResourceRecordSetsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ListResourceRecordSetsRequestMarshaller
implements Marshaller<Request<ListResourceRecordSetsRequest>, ListResourceRecordSetsRequest> {
    public Request<ListResourceRecordSetsRequest> marshall(ListResourceRecordSetsRequest listResourceRecordSetsRequest) {
        if (listResourceRecordSetsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listResourceRecordSetsRequest, "AmazonRoute53");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2013-04-01/hostedzone/{Id}/rrset";
        uriResourcePath = uriResourcePath.replace("{Id}", listResourceRecordSetsRequest.getHostedZoneId() != null ? StringUtils.fromString((String)listResourceRecordSetsRequest.getHostedZoneId()) : "");
        request.setResourcePath(uriResourcePath);
        if (listResourceRecordSetsRequest.getStartRecordName() != null) {
            request.addParameter("name", StringUtils.fromString((String)listResourceRecordSetsRequest.getStartRecordName()));
        }
        if (listResourceRecordSetsRequest.getStartRecordType() != null) {
            request.addParameter("type", StringUtils.fromString((String)listResourceRecordSetsRequest.getStartRecordType()));
        }
        if (listResourceRecordSetsRequest.getStartRecordIdentifier() != null) {
            request.addParameter("identifier", StringUtils.fromString((String)listResourceRecordSetsRequest.getStartRecordIdentifier()));
        }
        if (listResourceRecordSetsRequest.getMaxItems() != null) {
            request.addParameter("maxitems", StringUtils.fromString((String)listResourceRecordSetsRequest.getMaxItems()));
        }
        return request;
    }
}

