/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.route53.model.AliasTarget;
import com.amazonaws.services.route53.model.Change;
import com.amazonaws.services.route53.model.ChangeBatch;
import com.amazonaws.services.route53.model.ChangeResourceRecordSetsRequest;
import com.amazonaws.services.route53.model.GeoLocation;
import com.amazonaws.services.route53.model.ResourceRecord;
import com.amazonaws.services.route53.model.ResourceRecordSet;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.XMLWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ChangeResourceRecordSetsRequestMarshaller
implements Marshaller<Request<ChangeResourceRecordSetsRequest>, ChangeResourceRecordSetsRequest> {
    private static final String RESOURCE_PATH_TEMPLATE;
    private static final Map<String, String> STATIC_QUERY_PARAMS;
    private static final Map<String, String> DYNAMIC_QUERY_PARAMS;

    public Request<ChangeResourceRecordSetsRequest> marshall(ChangeResourceRecordSetsRequest changeResourceRecordSetsRequest) {
        ChangeBatch changeBatchChangeBatch;
        if (changeResourceRecordSetsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)changeResourceRecordSetsRequest, "AmazonRoute53");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = RESOURCE_PATH_TEMPLATE;
        if (DYNAMIC_QUERY_PARAMS.containsKey("Id")) {
            String value;
            String name = DYNAMIC_QUERY_PARAMS.get("Id");
            String string = value = changeResourceRecordSetsRequest.getHostedZoneId() == null ? null : StringUtils.fromString((String)changeResourceRecordSetsRequest.getHostedZoneId());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{Id}", changeResourceRecordSetsRequest.getHostedZoneId() == null ? "" : StringUtils.fromString((String)changeResourceRecordSetsRequest.getHostedZoneId()));
        }
        request.setResourcePath(uriResourcePath.replaceAll("//", "/"));
        for (Map.Entry<String, String> entry : STATIC_QUERY_PARAMS.entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        StringWriter stringWriter = new StringWriter();
        XMLWriter xmlWriter = new XMLWriter((Writer)stringWriter, "https://route53.amazonaws.com/doc/2013-04-01/");
        xmlWriter.startElement("ChangeResourceRecordSetsRequest");
        if (changeResourceRecordSetsRequest != null && (changeBatchChangeBatch = changeResourceRecordSetsRequest.getChangeBatch()) != null) {
            List<Change> changeBatchChangeBatchchangesList;
            xmlWriter.startElement("ChangeBatch");
            if (changeBatchChangeBatch.getComment() != null) {
                xmlWriter.startElement("Comment").value(changeBatchChangeBatch.getComment()).endElement();
            }
            if (changeBatchChangeBatch != null && (changeBatchChangeBatchchangesList = changeBatchChangeBatch.getChanges()) != null && changeBatchChangeBatchchangesList.size() > 0) {
                int changeBatchChangeBatchchangesListIndex = 1;
                xmlWriter.startElement("Changes");
                for (Change changeBatchChangeBatchchangesListValue : changeBatchChangeBatchchangesList) {
                    ResourceRecordSet resourceRecordSetResourceRecordSet;
                    xmlWriter.startElement("Change");
                    if (changeBatchChangeBatchchangesListValue.getAction() != null) {
                        xmlWriter.startElement("Action").value(changeBatchChangeBatchchangesListValue.getAction()).endElement();
                    }
                    if (changeBatchChangeBatchchangesListValue != null && (resourceRecordSetResourceRecordSet = changeBatchChangeBatchchangesListValue.getResourceRecordSet()) != null) {
                        AliasTarget aliasTargetAliasTarget;
                        List<ResourceRecord> resourceRecordSetResourceRecordSetresourceRecordsList;
                        GeoLocation geoLocationGeoLocation;
                        xmlWriter.startElement("ResourceRecordSet");
                        if (resourceRecordSetResourceRecordSet.getName() != null) {
                            xmlWriter.startElement("Name").value(resourceRecordSetResourceRecordSet.getName()).endElement();
                        }
                        if (resourceRecordSetResourceRecordSet.getType() != null) {
                            xmlWriter.startElement("Type").value(resourceRecordSetResourceRecordSet.getType()).endElement();
                        }
                        if (resourceRecordSetResourceRecordSet.getSetIdentifier() != null) {
                            xmlWriter.startElement("SetIdentifier").value(resourceRecordSetResourceRecordSet.getSetIdentifier()).endElement();
                        }
                        if (resourceRecordSetResourceRecordSet.getWeight() != null) {
                            xmlWriter.startElement("Weight").value((Object)resourceRecordSetResourceRecordSet.getWeight()).endElement();
                        }
                        if (resourceRecordSetResourceRecordSet.getRegion() != null) {
                            xmlWriter.startElement("Region").value(resourceRecordSetResourceRecordSet.getRegion()).endElement();
                        }
                        if (resourceRecordSetResourceRecordSet != null && (geoLocationGeoLocation = resourceRecordSetResourceRecordSet.getGeoLocation()) != null) {
                            xmlWriter.startElement("GeoLocation");
                            if (geoLocationGeoLocation.getContinentCode() != null) {
                                xmlWriter.startElement("ContinentCode").value(geoLocationGeoLocation.getContinentCode()).endElement();
                            }
                            if (geoLocationGeoLocation.getCountryCode() != null) {
                                xmlWriter.startElement("CountryCode").value(geoLocationGeoLocation.getCountryCode()).endElement();
                            }
                            if (geoLocationGeoLocation.getSubdivisionCode() != null) {
                                xmlWriter.startElement("SubdivisionCode").value(geoLocationGeoLocation.getSubdivisionCode()).endElement();
                            }
                            xmlWriter.endElement();
                        }
                        if (resourceRecordSetResourceRecordSet.getFailover() != null) {
                            xmlWriter.startElement("Failover").value(resourceRecordSetResourceRecordSet.getFailover()).endElement();
                        }
                        if (resourceRecordSetResourceRecordSet.getTTL() != null) {
                            xmlWriter.startElement("TTL").value((Object)resourceRecordSetResourceRecordSet.getTTL()).endElement();
                        }
                        if (resourceRecordSetResourceRecordSet != null && (resourceRecordSetResourceRecordSetresourceRecordsList = resourceRecordSetResourceRecordSet.getResourceRecords()) != null && resourceRecordSetResourceRecordSetresourceRecordsList.size() > 0) {
                            int resourceRecordSetResourceRecordSetresourceRecordsListIndex = 1;
                            xmlWriter.startElement("ResourceRecords");
                            for (ResourceRecord resourceRecordSetResourceRecordSetresourceRecordsListValue : resourceRecordSetResourceRecordSetresourceRecordsList) {
                                xmlWriter.startElement("ResourceRecord");
                                if (resourceRecordSetResourceRecordSetresourceRecordsListValue.getValue() != null) {
                                    xmlWriter.startElement("Value").value(resourceRecordSetResourceRecordSetresourceRecordsListValue.getValue()).endElement();
                                }
                                xmlWriter.endElement();
                                ++resourceRecordSetResourceRecordSetresourceRecordsListIndex;
                            }
                            xmlWriter.endElement();
                        }
                        if (resourceRecordSetResourceRecordSet != null && (aliasTargetAliasTarget = resourceRecordSetResourceRecordSet.getAliasTarget()) != null) {
                            xmlWriter.startElement("AliasTarget");
                            if (aliasTargetAliasTarget.getHostedZoneId() != null) {
                                xmlWriter.startElement("HostedZoneId").value(aliasTargetAliasTarget.getHostedZoneId()).endElement();
                            }
                            if (aliasTargetAliasTarget.getDNSName() != null) {
                                xmlWriter.startElement("DNSName").value(aliasTargetAliasTarget.getDNSName()).endElement();
                            }
                            if (aliasTargetAliasTarget.isEvaluateTargetHealth() != null) {
                                xmlWriter.startElement("EvaluateTargetHealth").value((Object)aliasTargetAliasTarget.isEvaluateTargetHealth()).endElement();
                            }
                            xmlWriter.endElement();
                        }
                        if (resourceRecordSetResourceRecordSet.getHealthCheckId() != null) {
                            xmlWriter.startElement("HealthCheckId").value(resourceRecordSetResourceRecordSet.getHealthCheckId()).endElement();
                        }
                        if (resourceRecordSetResourceRecordSet.getTrafficPolicyInstanceId() != null) {
                            xmlWriter.startElement("TrafficPolicyInstanceId").value(resourceRecordSetResourceRecordSet.getTrafficPolicyInstanceId()).endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                    ++changeBatchChangeBatchchangesListIndex;
                }
                xmlWriter.endElement();
            }
            xmlWriter.endElement();
        }
        xmlWriter.endElement();
        try {
            request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            request.addHeader("Content-Type", "application/xml");
        }
        catch (UnsupportedEncodingException e) {
            throw new AmazonClientException("Unable to marshall request to XML", (Throwable)e);
        }
        return request;
    }

    static {
        String path = "/2013-04-01/hostedzone/{Id}/rrset/";
        HashMap<String, String> staticMap = new HashMap<String, String>();
        HashMap<String, String> dynamicMap = new HashMap<String, String>();
        int index = path.indexOf("?");
        if (index != -1) {
            String queryString = path.substring(index + 1);
            path = path.substring(0, index);
            for (String s : queryString.split("[;&]")) {
                index = s.indexOf("=");
                if (index == -1) continue;
                String name = s.substring(0, index);
                String value = s.substring(index + 1);
                if (value.startsWith("{") && value.endsWith("}")) {
                    dynamicMap.put(value.substring(1, value.length() - 1), name);
                    continue;
                }
                staticMap.put(name, value);
            }
        }
        RESOURCE_PATH_TEMPLATE = path;
        STATIC_QUERY_PARAMS = Collections.unmodifiableMap(staticMap);
        DYNAMIC_QUERY_PARAMS = Collections.unmodifiableMap(dynamicMap);
    }
}

