/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53domains.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.route53domains.model.Tag;
import com.amazonaws.services.route53domains.model.UpdateTagsForDomainRequest;
import com.amazonaws.services.route53domains.model.transform.TagJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class UpdateTagsForDomainRequestMarshaller
implements Marshaller<Request<UpdateTagsForDomainRequest>, UpdateTagsForDomainRequest> {
    public Request<UpdateTagsForDomainRequest> marshall(UpdateTagsForDomainRequest updateTagsForDomainRequest) {
        if (updateTagsForDomainRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateTagsForDomainRequest, "AmazonRoute53Domains");
        request.addHeader("X-Amz-Target", "Route53Domains_v20140515.UpdateTagsForDomain");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList tagsToUpdateList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (updateTagsForDomainRequest.getDomainName() != null) {
                jsonWriter.key("DomainName").value((Object)updateTagsForDomainRequest.getDomainName());
            }
            if (!(tagsToUpdateList = (SdkInternalList)updateTagsForDomainRequest.getTagsToUpdate()).isEmpty() || !tagsToUpdateList.isAutoConstruct()) {
                jsonWriter.key("TagsToUpdate");
                jsonWriter.array();
                for (Tag tagsToUpdateListValue : tagsToUpdateList) {
                    if (tagsToUpdateListValue == null) continue;
                    TagJsonMarshaller.getInstance().marshall(tagsToUpdateListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

